#include <iostream>

#include <hugo/maps.h>
#include <hugo/unionfind.h>
#include "test_tools.h"

using namespace hugo;
using namespace std;

template <typename T>
class BaseMap : public StdMap<int,T> {};

typedef UnionFindEnum<int, BaseMap> UFE;

void print(UFE const &ufe) {
  UFE::ClassIt cit;
  cout << "Print the classes of the structure:" << endl;
  int i = 1;
  for (ufe.first(cit); ufe.valid(cit); ufe.next(cit)) {
    cout << "  " << i << " (" << cit << "):" << flush;
    UFE::ItemIt iit;
    for (ufe.first(iit, cit); ufe.valid(iit); ufe.next(iit)) {
      cout << " " << iit << flush;
    }
    cout << endl;
    i++;
  }
  cout << "done" << endl;
}


int main() {
  UFE::MapType base;
  UFE U(base);

//   print(U);

  cout << "Insert 1..." << endl;
  U.insert(1);
//   print(U);
  
  cout << "Insert 2..." << endl;
  U.insert(2);
//   print(U);
  
  cout << "Join 1 and 2..." << endl;
  check(U.join(1,2),"Test failed.");
//   print(U);

  cout << "Insert 3, 4, 5, 6, 7..." << endl;
  U.insert(3);
  U.insert(4);
  U.insert(5);
  U.insert(6);
  U.insert(7);
//   print (U);

  cout << "Join 1 - 4, 2 - 4 and 3 - 5 ..." << endl;
  check(U.join(1,4),"Test failed.");
  check(!U.join(2,4),"Test failed.");
  check(U.join(3,5),"Test failed.");
//   print(U);

  cout << "Insert 8 to the component of 5 ..." << endl;
  U.insert(8,5);
//   print(U);

  cout << "Size of the class of 4: " << U.size(4) << endl;
  check(U.size(4) == 3,"Test failed.");
  cout << "Size of the class of 5: " << U.size(5) << endl;
  check(U.size(5) == 3,"Test failed.");
  cout << "Size of the class of 6: " << U.size(6) << endl;
  check(U.size(6) == 1,"Test failed.");
  cout << "Size of the class of 2: " << U.size(2) << endl;
  check(U.size(2) == 3,"Test failed.");

  cout << "Insert 9 ..." << endl;
  U.insert(9);
//   print(U);
  cout << "Insert 10 to the component of 9 ..." << endl;
  U.insert(10,9);
//   print(U);

  cout << "Join 8 and 10..." << endl;
  check(U.join(8,10),"Test failed.");
//   print(U);

  cout << "Move 9 to the class of 4 ..." << endl;
  check(U.move(9,4),"Test failed.");
//   print(U);

  cout << "Move 9 to the class of 2 ..." << endl;
  check(!U.move(9,2),"Test failed.");
//   print(U);

  cout << "Size of the class of 4: " << U.size(4) << endl;
  check(U.size(4) == 4,"Test failed.");
  cout << "Size of the class of 9: " << U.size(9) << endl;
  check(U.size(9) == 4,"Test failed.");
  
  cout << "Move 5 to the class of 6 ..." << endl;
  check(U.move(5,6),"Test failed.");
//   print(U);

  cout << "Size of the class of 5: " << U.size(5) << endl;
  check(U.size(5) == 2,"Test failed.");
  cout << "Size of the class of 8: " << U.size(8) << endl;
  check(U.size(8) == 3,"Test failed.");

  cout << "Move 7 to the class of 10 ..." << endl;
  check(U.move(7,10),"Test failed.");
//   print(U);

  cout << "Size of the class of 7: " << U.size(7) << endl;
  check(U.size(7) == 4,"Test failed.");

  cout <<"Erase 9... " << endl;
  U.erase(9);
//   print(U);

  cout <<"Erase 1... " << endl;
  U.erase(1);
//   print(U);

  cout << "Size of the class of 4: " << U.size(4) << endl;
  check(U.size(4) == 2,"Test failed.");
  cout << "Size of the class of 2: " << U.size(2) << endl;
  check(U.size(2) == 2,"Test failed.");


  cout <<"Erase 1... " << endl;
  U.erase(1);
//   print(U);

  cout <<"Erase 6... " << endl;
  U.erase(6);
//   print(U);

  cout << "Split the class of 8... " << endl;
  U.split(8);
//   print(U);


  cout << "Size of the class of 4: " << U.size(4) << endl;
  check(U.size(4) == 2,"Test failed.");
  cout << "Size of the class of 3: " << U.size(3) << endl;
  check(U.size(3) == 1,"Test failed.");
  cout << "Size of the class of 2: " << U.size(2) << endl;
  check(U.size(2) == 2,"Test failed.");


  cout << "Join 3 - 4 and 2 - 4 ..." << endl;
  check(U.join(3,4),"Test failed.");
  check(!U.join(2,4),"Test failed.");
//   print(U);


  cout << "Size of the class of 4: " << U.size(4) << endl;
  check(U.size(4) == 3,"Test failed.");
  cout << "Size of the class of 3: " << U.size(3) << endl;
  check(U.size(3) == 3,"Test failed.");
  cout << "Size of the class of 2: " << U.size(2) << endl;
  check(U.size(2) == 3,"Test failed.");

  cout << "makeRep(4)..." << endl;
  U.makeRep(4);
//   print(U);
  cout << "makeRep(3)..." << endl;
  U.makeRep(3);
//   print(U);
  cout << "makeRep(2)..." << endl;
  U.makeRep(2);
//   print(U);

  cout << "Size of the class of 4: " << U.size(4) << endl;
  check(U.size(4) == 3,"Test failed.");
  cout << "Size of the class of 3: " << U.size(3) << endl;
  check(U.size(3) == 3,"Test failed.");
  cout << "Size of the class of 2: " << U.size(2) << endl;
  check(U.size(2) == 3,"Test failed.");


  cout << "eraseClass 4 ..." << endl;
  U.eraseClass(4);
//   print(U);

  cout << "eraseClass 7 ..." << endl;
  U.eraseClass(7);
//   print(U);

  cout << "done." << endl;
}
