#include <iostream>
#include <vector>
#include <string>

#include <marci_list_graph.hh>
#include <marci_graph_traits.hh>
#include <marci_property_vector.hh>
#include <preflow_push_hl.hh>
#include <preflow_push_max_flow.hh>
#include <reverse_bfs.hh>
//#include <dijkstra.hh>

using namespace marci;


int main (int, char*[])
{
  typedef graph_traits<list_graph>::node_iterator node_iterator;
  typedef graph_traits<list_graph>::edge_iterator edge_iterator;
  typedef graph_traits<list_graph>::each_node_iterator each_node_iterator;
  typedef graph_traits<list_graph>::each_edge_iterator each_edge_iterator;
  typedef graph_traits<list_graph>::out_edge_iterator out_edge_iterator;
  typedef graph_traits<list_graph>::in_edge_iterator in_edge_iterator;
  typedef graph_traits<list_graph>::sym_edge_iterator sym_edge_iterator;

  list_graph flow_test;
 
    //Ahuja knyv pldja, maxflowvalue=13
  node_iterator s=flow_test.add_node();
  node_iterator v1=flow_test.add_node();
  node_iterator v2=flow_test.add_node();
  node_iterator v3=flow_test.add_node();
  node_iterator v4=flow_test.add_node();
  node_iterator v5=flow_test.add_node();
  node_iterator t=flow_test.add_node();
  
  node_property_vector<list_graph, std::string> node_name(flow_test);
  node_name.put(s, "s");
  node_name.put(v1, "v1");
  node_name.put(v2, "v2");
  node_name.put(v3, "v3");
  node_name.put(v4, "v4");
  node_name.put(v5, "v5");
  node_name.put(t, "t");

  edge_iterator s_v1=flow_test.add_edge(s, v1);
  edge_iterator s_v2=flow_test.add_edge(s, v2);
  edge_iterator s_v3=flow_test.add_edge(s, v3);
  edge_iterator v2_v4=flow_test.add_edge(v2, v4);
  edge_iterator v2_v5=flow_test.add_edge(v2, v5);
  edge_iterator v3_v5=flow_test.add_edge(v3, v5);
  edge_iterator v4_t=flow_test.add_edge(v4, t);
  edge_iterator v5_t=flow_test.add_edge(v5, t);
  edge_iterator v2_s=flow_test.add_edge(v2, s);
  
  edge_property_vector<list_graph, int> cap(flow_test);  
  cap.put(s_v1, 0);
  cap.put(s_v2, 10);
  cap.put(s_v3, 10);
  cap.put(v2_v4, 5);
  cap.put(v2_v5, 8);
  cap.put(v3_v5, 5);
  cap.put(v4_t, 8);
  cap.put(v5_t, 8);
  cap.put(v2_s, 0);


  
  //Marci pldja, maxflowvalue=23
  /*  node_iterator s=flow_test.add_node();
  node_iterator v1=flow_test.add_node();
  node_iterator v2=flow_test.add_node();
  node_iterator v3=flow_test.add_node();
  node_iterator v4=flow_test.add_node();
  node_iterator t=flow_test.add_node();
  node_iterator w=flow_test.add_node();

  
  node_property_vector<list_graph, std::string> node_name(flow_test);
  node_name.put(s, "s");
  node_name.put(v1, "v1");
  node_name.put(v2, "v2");
  node_name.put(v3, "v3");
  node_name.put(v4, "v4");
  node_name.put(t, "t");
  node_name.put(w, "w");

  edge_iterator s_v1=flow_test.add_edge(s, v1);
  edge_iterator s_v2=flow_test.add_edge(s, v2);
  edge_iterator v1_v2=flow_test.add_edge(v1, v2);
  edge_iterator v2_v1=flow_test.add_edge(v2, v1);
  edge_iterator v1_v3=flow_test.add_edge(v1, v3);
  edge_iterator v3_v2=flow_test.add_edge(v3, v2);
  edge_iterator v2_v4=flow_test.add_edge(v2, v4);
  edge_iterator v4_v3=flow_test.add_edge(v4, v3);
  edge_iterator v3_t=flow_test.add_edge(v3, t);
  edge_iterator v4_t=flow_test.add_edge(v4, t);
  edge_iterator v3_v3=flow_test.add_edge(v3, v3);
  edge_iterator s_w=flow_test.add_edge(s, w);
  //  edge_iterator v2_s=flow_test.add_edge(v2, s);
  


  edge_property_vector<list_graph, int> cap(flow_test);  //serves as length in dijkstra
  cap.put(s_v1, 16);
  cap.put(s_v2, 13);
  cap.put(v1_v2, 10);
  cap.put(v2_v1, 4);
  cap.put(v1_v3, 12);
  cap.put(v3_v2, 9);
  cap.put(v2_v4, 14);
  cap.put(v4_v3, 7);
  cap.put(v3_t, 20);
  cap.put(v4_t, 4);
  cap.put(v3_v3, 4);
  cap.put(s_w, 4);
  //  cap.put(v2_s, 0);

*/

  //pelda 3, maxflowvalue=4
  /*      node_iterator s=flow_test.add_node();
  node_iterator v1=flow_test.add_node();
  node_iterator v2=flow_test.add_node();
  node_iterator t=flow_test.add_node();
  node_iterator w=flow_test.add_node();
  
  node_property_vector<list_graph, std::string> node_name(flow_test);
  node_name.put(s, "s");
  node_name.put(v1, "v1");
  node_name.put(v2, "v2");
  node_name.put(t, "t");
  node_name.put(w, "w");

  edge_iterator s_v1=flow_test.add_edge(s, v1);
  edge_iterator v1_v2=flow_test.add_edge(v1, v2);
  edge_iterator v2_t=flow_test.add_edge(v2, t);
  edge_iterator v1_v1=flow_test.add_edge(v1, v1);
  edge_iterator s_w=flow_test.add_edge(s, w);


  edge_property_vector<list_graph, int> cap(flow_test); 
    
  cap.put(s_v1, 16);
  cap.put(v1_v2, 10);
  cap.put(v2_t, 4);
  cap.put(v1_v1, 3);
  cap.put(s_w, 5);
  */
  


  /*
  std::cout << "Testing reverse_bfs..." << std::endl;
  
  reverse_bfs<list_graph> bfs_test(flow_test, t);

  bfs_test.run();

  for (each_node_iterator w=flow_test.first_node(); w.valid(); ++w) {
    std::cout <<"The distance of " << w << " is " << bfs_test.dist(w) <<std::endl;
    }

  */



  std::cout << "Testing preflow_push_hl..." << std::endl;
  
  preflow_push_hl<list_graph, int> preflow_push_test(flow_test, s, t, cap);

  preflow_push_test.run();

  std::cout << "Maximum flow value is: " << preflow_push_test.maxflow() << "."<<std::endl;

  std::cout<< "The flow on edge s-v1 is "<< preflow_push_test.flowonedge(s_v1) << "."<<std::endl;

  edge_property_vector<list_graph, int> flow=preflow_push_test.allflow();  
  for (each_edge_iterator e=flow_test.first_edge(); e.valid(); ++e) {
    std::cout <<"Flow on edge " << flow_test.tail(e) <<"-" << flow_test.head(e)<< " is " <<flow.get(e) <<std::endl;
    }

  std::cout << "A minimum cut: " <<std::endl;  
  node_property_vector<list_graph, bool> mincut=preflow_push_test.mincut();

  for (each_node_iterator v=flow_test.first_node(); v.valid(); ++v) {
      if (mincut.get(v)) std::cout <<node_name.get(v)<< " ";
    }
  
  std::cout<<"\n\n"<<std::endl;




  std::cout << "Testing preflow_push_max_flow..." << std::endl;
 
  preflow_push_max_flow<list_graph, int> max_flow_test(flow_test, s, t, cap);

  max_flow_test.run();

  std::cout << "Maximum flow value is: " << max_flow_test.maxflow() << "."<< std::endl;

  std::cout << "A minimum cut: " <<std::endl;  
  node_property_vector<list_graph, bool> mincut2=max_flow_test.mincut();

  for (each_node_iterator v=flow_test.first_node(); v.valid(); ++v) {
    if (mincut2.get(v)) std::cout <<node_name.get(v)<< " ";
  }
  
  std::cout << std::endl <<std::endl;


  /*
    std::cout << "Testing dijkstra..." << std::endl;
  
    node_iterator root=v2;

    dijkstra<list_graph, int> dijkstra_test(flow_test, root, cap);

    dijkstra_test.run();

    for (each_node_iterator w=flow_test.first_node(); w.valid(); ++w) {
      if (dijkstra_test.reach(w)) {
      std::cout <<"The distance of " << w << " is " << dijkstra_test.dist(w);
      if (dijkstra_test.pred(w).valid()) {
      std::cout <<", a shortest path from the root ends with edge " << dijkstra_test.pred(w) <<std::endl; 
      } else {
       std::cout <<", this is the root."<<std::endl; }
      
      } else {
	cout << w << " is not reachable from " << root <<std::endl;
      }
    }

  */

  return 0;
}









