#include <sys/time.h>
#include <iostream>
#include <fstream>

#include <list_graph.hh>
#include <dimacs.hh>
#include <edmonds_karp.hh>

using namespace marci;

double currTime() {
  timeval tv;
  //timezone tz;
  gettimeofday(&tv, 0);
  return double(tv.tv_sec)+double(tv.tv_usec)/1000000.0;
}

// Use a DIMACS max flow file as stdin.
// read_dimacs_demo < dimacs_flow_file
int main(int, char **) {
  typedef ListGraph::NodeIt NodeIt;
  typedef ListGraph::EachEdgeIt EachEdgeIt;

  ListGraph G;
  NodeIt s, t;
  ListGraph::EdgeMap<int> cap(G);
  readDimacsMaxFlow(std::cin, G, s, t, cap);

  std::cout << "augmenting path flow algorithm demo..." << std::endl;
  ListGraph::EdgeMap<int> flow(G); //0 flow

  double preTime=currTime();
  MaxFlow<ListGraph, int, ListGraph::EdgeMap<int>, ListGraph::EdgeMap<int> > max_flow_test(G, s, t, flow, cap);
  max_flow_test.run();
  double pushTime=currTime();
  std::cout << "maximum flow: "<< std::endl;
  for(EachEdgeIt e=G.first<EachEdgeIt>(); e.valid(); ++e) { 
    std::cout<<"("<<G.tail(e)<< "-"<<flow.get(e)<<"->"<<G.head(e)<<") ";
  }
  std::cout<<std::endl;
  std::cout << "elapsed time: " << pushTime-preTime << " sec"<< std::endl; 
  std::cout << "flow value: "<< max_flow_test.flowValue() << std::endl;

  return 0;
}
