#include <iostream>
#include <fstream>

#include <list_graph.hh>
#include <dimacs.hh>
#include <dijkstra.h>
#include <time_measure.h>
#include <bin_heap.hh>

using namespace hugo;

int main(int, char **) {
  
  typedef ListGraph Graph;

  typedef Graph::Node Node;
  typedef Graph::EdgeIt EdgeIt;

  Graph G;
  Node s, t;
  Graph::EdgeMap<int> cap(G);
  readDimacsMaxFlow(std::cin, G, s, t, cap);
  Timer ts;
  
  std::cout << "Testing dijkstra.h with Fibonacci-heap 
implementation fib_heap.h ..." << std::endl;
  
  Dijkstra<Graph, int
      //      , BinHeap<ListGraph::NodeIt, int, ListGraph::NodeMap<int> > 
> dijkstra_test(G, s, cap);
   ts.reset();
    dijkstra_test.run();
    std::cout << "elapsed time: " << ts << std::endl;
  double post_time=currTime();
    
  std::cout << "running time: " << post_time-pre_time << " sec"<< std::endl; 
 
  EachEdgeIt e;

  int hiba=0;

  int edge=0;

  for ( G.getFirst(e) ; G.valid(e); G.next(e) ) {
    NodeIt u=G.tail(e);
    NodeIt v=G.head(e);
    ++edge;
    if ( dijkstra_test.dist(v) - dijkstra_test.dist(u) > cap.get(e) ) {
      std::cout<<"Hiba: "<<edge<<": "<<dijkstra_test.dist(v) - dijkstra_test.dist(u) - cap.get(e)<<std::endl;
      ++hiba;
    }
  }

  std::cout << "Osszhibas el: " << hiba << " osszel: " << G.edgeNum() << std::endl;

  return 0;
}
