#include <iostream>

#include <smart_graph.h>
#include <list_graph.h>
#include <dimacs.h>
#include <preflowproba.h>
#include <time_measure.h>

using namespace hugo;

int main(int, char **) {
 
  typedef SmartGraph Graph;
  
  typedef Graph::Node Node;
  typedef Graph::EdgeIt EdgeIt;

  Graph G;
  Node s, t;
  Graph::EdgeMap<int> cap(G);
  readDimacsMaxFlow(std::cin, G, s, t, cap);
  Timer ts;
  
  std::cout << "preflow demo ..." << std::endl;
  
  Graph::EdgeMap<int> flow(G);
  Preflow<Graph, int> max_flow_test(G, s, t, cap, flow, 1);
  ts.reset();
  max_flow_test.run();
  std::cout << "elapsed time: " << ts << std::endl;
  
  Graph::NodeMap<bool> cut(G);
  max_flow_test.minCut(cut); 
  int min_cut_value=0;
  EdgeIt e;
  for(G.first(e); G.valid(e); G.next(e)) {
    if (cut[G.tail(e)] && !cut[G.head(e)]) min_cut_value+=cap[e];
  }

  Graph::NodeMap<bool> cut1(G);
  max_flow_test.minMinCut(cut1); 
  int min_min_cut_value=0;
  for(G.first(e); G.valid(e); G.next(e)) {
    if (cut[G.tail(e)] && !cut[G.head(e)]) 
      min_min_cut_value+=cap[e];
  }

  Graph::NodeMap<bool> cut2(G);
  max_flow_test.maxMinCut(cut2); 
  int max_min_cut_value=0;
  for(G.first(e); G.valid(e); G.next(e)) {
    if (cut2[G.tail(e)] && !cut2[G.head(e)]) 
      max_min_cut_value+=cap[e];
      }
  
  std::cout << "flow value: "<< max_flow_test.flowValue() << std::endl;
  std::cout << "min cut value: "<< min_cut_value << std::endl;
  std::cout << "min min cut value: "<< min_min_cut_value << std::endl;
  std::cout << "max min cut value: "<< max_min_cut_value << 
    std::endl<< std::endl;
  
  return 0;
}
