// -*- c++ -*-
#include <iostream>
#include <cstdlib>
#include "list_graph.h"

using namespace std;
using namespace lemon;



int main() {
  ListGraph g;
  for (int i = 0; i < 10; ++i) {
    ListGraph::Node node = g.addNode();
  }
  ListGraph::NodeMap<int> map(g, 10);
  for (int i = 0; i < 10; ++i) {
    ListGraph::Node node = g.addNode();
    map[node] = rand()%100;
  }
  for (ListGraph::NodeIt it(g); g.valid(it); g.next(it)) {
    cout << map[it] << endl;
  }
  ListGraph::NodeMap<int>::iterator pit;
  for (pit = map.begin(); pit != map.end(); ++pit) {
    cout << g.id(pit->first) << ' ' << pit->second << endl;
    (*pit).second = g.id(pit->first);
    cout << g.id((*pit).first) << ' ' << (*pit).second << endl;
  }  
  const ListGraph::NodeMap<int> const_map = map;
  ListGraph::NodeMap<int>::const_iterator cit;
  for (cit = const_map.begin(); cit != const_map.end(); ++cit) {
    cerr << g.id(cit->first) << ' ' << cit->second << endl;
    cerr << g.id((*cit).first) << ' ' << (*cit).second << endl;
  }  
  return 0;
}

