// -*- c++ -*-
#ifndef LEMON_GRAPH_WRAPPER_H
#define LEMON_GRAPH_WRAPPER_H

#include <invalid.h>

namespace lemon {

  template<typename Graph>
  class TrivGraphWrapper {
  protected:
    Graph* graph;
  
  public:
    typedef Graph BaseGraph;

//     TrivGraphWrapper() : graph(0) { }
    TrivGraphWrapper(Graph& _graph) : graph(&_graph) { }
//     void setGraph(Graph& _graph) { graph = &_graph; }
//     Graph& getGraph() const { return *graph; }

    typedef typename Graph::Node Node;
    class NodeIt : public Graph::NodeIt { 
    public:
      NodeIt() { }
      NodeIt(const typename Graph::NodeIt& n) : Graph::NodeIt(n) { }
      NodeIt(const Invalid& i) : Graph::NodeIt(i) { }
      NodeIt(const TrivGraphWrapper<Graph>& _G) : 
	Graph::NodeIt(*(_G.graph)) { }
    };
    typedef typename Graph::Edge Edge;
    class OutEdgeIt : public Graph::OutEdgeIt { 
    public:
      OutEdgeIt() { }
      OutEdgeIt(const typename Graph::OutEdgeIt& e) : Graph::OutEdgeIt(e) { }
      OutEdgeIt(const Invalid& i) : Graph::OutEdgeIt(i) { }
      OutEdgeIt(const TrivGraphWrapper<Graph>& _G, const Node& n) : 
	Graph::OutEdgeIt(*(_G.graph), n) { }
    };
    class InEdgeIt : public Graph::InEdgeIt { 
    public:
      InEdgeIt() { }
      InEdgeIt(const typename Graph::InEdgeIt& e) : Graph::InEdgeIt(e) { }
      InEdgeIt(const Invalid& i) : Graph::InEdgeIt(i) { }
      InEdgeIt(const TrivGraphWrapper<Graph>& _G, const Node& n) : 
	Graph::InEdgeIt(*(_G.graph), n) { }
    };
    //typedef typename Graph::SymEdgeIt SymEdgeIt;
    class EdgeIt : public Graph::EdgeIt { 
    public:
      EdgeIt() { }
      EdgeIt(const typename Graph::EdgeIt& e) : Graph::EdgeIt(e) { }
      EdgeIt(const Invalid& i) : Graph::EdgeIt(i) { }
      EdgeIt(const TrivGraphWrapper<Graph>& _G) : 
	Graph::EdgeIt(*(_G.graph)) { }
    };

    NodeIt& first(NodeIt& i) const { 
      i=NodeIt(*this);
      return i;
    }
    EdgeIt& first(EdgeIt& i) const { 
      i=EdgeIt(*this);
      return i;
    }
//     template<typename I> I& first(I& i) const { 
//       i=I(*this);
//       return i;
//     }
    OutEdgeIt& first(OutEdgeIt& i, const Node& p) const { 
      i=OutEdgeIt(*this, p);
      return i;
    }
    InEdgeIt& first(InEdgeIt& i, const Node& p) const { 
      i=InEdgeIt(*this, p);
      return i;
    }
//     template<typename I, typename P> I& first(I& i, const P& p) const { 
//       i=I(*this, p);
//       return i;
//     }
    
//    template<typename I> I getNext(const I& i) const { 
//      return graph->getNext(i); }
    template<typename I> I& next(I &i) const { graph->next(i); return i; }    

    template< typename It > It first() const { 
      It e; this->first(e); return e; }

    template< typename It > It first(const Node& v) const { 
      It e; this->first(e, v); return e; }

    Node target(const Edge& e) const { return graph->target(e); }
    Node source(const Edge& e) const { return graph->source(e); }

    template<typename I> bool valid(const I& i) const { 
      return graph->valid(i); }
  
    //template<typename I> void setInvalid(const I &i);
    //{ return graph->setInvalid(i); }

    int nodeNum() const { return graph->nodeNum(); }
    int edgeNum() const { return graph->edgeNum(); }
  
    template<typename I> Node aNode(const I& e) const { 
      return graph->aNode(e); }
    template<typename I> Node bNode(const I& e) const { 
      return graph->bNode(e); }
  
    Node addNode() const { return graph->addNode(); }
    Edge addEdge(const Node& source, const Node& target) const { 
      return graph->addEdge(source, target); }
  
    template<typename I> void erase(const I& i) const { graph->erase(i); }
  
    void clear() const { graph->clear(); }
    
    template<typename T> class NodeMap : public Graph::NodeMap<T> { 
    public:
      NodeMap(const TrivGraphWrapper<Graph>& _G) :  
	Graph::NodeMap<T>(*(_G.graph)) { }
      NodeMap(const TrivGraphWrapper<Graph>& _G, T a) : 
	Graph::NodeMap<T>(*(_G.graph), a) { }
    };

    template<typename T> class EdgeMap : public Graph::EdgeMap<T> { 
    public:
      EdgeMap(const TrivGraphWrapper<Graph>& _G) :  
	Graph::EdgeMap<T>(*(_G.graph)) { }
      EdgeMap(const TrivGraphWrapper<Graph>& _G, T a) : 
	Graph::EdgeMap<T>(*(_G.graph), a) { }
    };

    template<typename Map, typename T> class NodeMapWrapper {
    protected:
      Map* map;
    public:
      NodeMapWrapper(Map& _map) : map(&_map) { }
      void set(Node n, T a) { map->set(n, a); }
      T get(Node n) const { return map->get(n); }
    };

    template<typename Map, typename T> class EdgeMapWrapper {
    protected:
      Map* map;
    public:
      EdgeMapWrapper(Map& _map) : map(&_map) { }
      void set(Edge n, T a) { map->set(n, a); }
      T get(Edge n) const { return map->get(n); }
    };
  };


  template<typename Graph>
  class GraphWrapper {
  protected:
    Graph* graph;
  
  public:
    typedef Graph BaseGraph;

//     GraphWrapper() : graph(0) { }
    GraphWrapper(Graph& _graph) : graph(&_graph) { }
//     void setGraph(Graph& _graph) { graph=&_graph; }
//     Graph& getGraph() const { return *graph; }
 
    typedef typename Graph::Node Node;
    class NodeIt : public Graph::NodeIt { 
    public:
      NodeIt() { }
      NodeIt(const typename Graph::NodeIt& n) : Graph::NodeIt(n) { }
      NodeIt(const Invalid& i) : Graph::NodeIt(i) { }
      NodeIt(const GraphWrapper<Graph>& _G) : 
	Graph::NodeIt(*(_G.graph)) { }
    };
    typedef typename Graph::Edge Edge;
    class OutEdgeIt : public Graph::OutEdgeIt { 
    public:
      OutEdgeIt() { }
      OutEdgeIt(const typename Graph::OutEdgeIt& e) : Graph::OutEdgeIt(e) { }
      OutEdgeIt(const Invalid& i) : Graph::OutEdgeIt(i) { }
      OutEdgeIt(const GraphWrapper<Graph>& _G, const Node& n) : 
	Graph::OutEdgeIt(*(_G.graph), n) { }
    };
    class InEdgeIt : public Graph::InEdgeIt { 
    public:
      InEdgeIt() { }
      InEdgeIt(const typename Graph::InEdgeIt& e) : Graph::InEdgeIt(e) { }
      InEdgeIt(const Invalid& i) : Graph::InEdgeIt(i) { }
      InEdgeIt(const GraphWrapper<Graph>& _G, const Node& n) : 
	Graph::InEdgeIt(*(_G.graph), n) { }
    };
    //typedef typename Graph::SymEdgeIt SymEdgeIt;
    class EdgeIt : public Graph::EdgeIt { 
    public:
      EdgeIt() { }
      EdgeIt(const typename Graph::EdgeIt& e) : Graph::EdgeIt(e) { }
      EdgeIt(const Invalid& i) : Graph::EdgeIt(i) { }
      EdgeIt(const GraphWrapper<Graph>& _G) : 
	Graph::EdgeIt(*(_G.graph)) { }
    };
   
    NodeIt& first(NodeIt& i) const { 
      i=NodeIt(*this);
      return i;
    }
    EdgeIt& first(EdgeIt& i) const { 
      i=EdgeIt(*this);
      return i;
    }
//     template<typename I> I& first(I& i) const {       
//       i=I(*this);
//       return i;
//     }
    OutEdgeIt& first(OutEdgeIt& i, const Node& p) const { 
      i=OutEdgeIt(*this, p);
      return i;
    }
    InEdgeIt& first(InEdgeIt& i, const Node& p) const { 
      i=InEdgeIt(*this, p);
      return i;
    }
//     template<typename I, typename P> I& first(I& i, const P& p) const { 
//       i=I(*this, p);
//       return i; 
//     }
    
//    template<typename I> I getNext(const I& i) const { 
//      return gw.getNext(i); }
    template<typename I> I& next(I &i) const { graph->next(i); return i; }    

    template< typename It > It first() const { 
      It e; this->first(e); return e; }

    template< typename It > It first(const Node& v) const { 
      It e; this->first(e, v); return e; }

    Node target(const Edge& e) const { return graph->target(e); }
    Node source(const Edge& e) const { return graph->source(e); }

    template<typename I> bool valid(const I& i) const { 
      return graph->valid(i); }
  
    //template<typename I> void setInvalid(const I &i);
    //{ return graph->setInvalid(i); }

    int nodeNum() const { return graph->nodeNum(); }
    int edgeNum() const { return graph->edgeNum(); }
  
    template<typename I> Node aNode(const I& e) const { 
      return graph->aNode(e); }
    template<typename I> Node bNode(const I& e) const { 
      return graph->bNode(e); }
  
    Node addNode() const { return graph->addNode(); }
    Edge addEdge(const Node& source, const Node& target) const { 
      return graph->addEdge(source, target); }
  
    template<typename I> void erase(const I& i) const { graph->erase(i); }
  
    void clear() const { graph->clear(); }
    
    template<typename T> class NodeMap : public Graph::NodeMap<T> { 
    public:
      NodeMap(const GraphWrapper<Graph>& _G) :  
	Graph::NodeMap<T>(*(_G.graph)) { }
      NodeMap(const GraphWrapper<Graph>& _G, T a) : 
	Graph::NodeMap<T>(*(_G.graph), a) { }
    };

    template<typename T> class EdgeMap : public Graph::EdgeMap<T> { 
    public:
      EdgeMap(const GraphWrapper<Graph>& _G) :  
	Graph::EdgeMap<T>(*(_G.graph)) { }
      EdgeMap(const GraphWrapper<Graph>& _G, T a) : 
	Graph::EdgeMap<T>(*(_G.graph), a) { }
    };
  };


//   template<typename Graph>
//   class RevGraphWrapper
//   {
//   protected:
//     Graph* graph;
  
//   public:
//     typedef Graph BaseGraph;

//     typedef typename Graph::Node Node;    
//     typedef typename Graph::NodeIt NodeIt;
  
//     typedef typename Graph::Edge Edge;
//     typedef typename Graph::OutEdgeIt InEdgeIt;
//     typedef typename Graph::InEdgeIt OutEdgeIt;
//     //typedef typename Graph::SymEdgeIt SymEdgeIt;
//     typedef typename Graph::EdgeIt EdgeIt;

//     //RevGraphWrapper() : graph(0) { }
//     RevGraphWrapper(Graph& _graph) : graph(&_graph) { }

//     void setGraph(Graph& _graph) { graph = &_graph; }
//     Graph& getGraph() const { return (*graph); }
    
//     template<typename I> I& first(I& i) const { return graph->first(i); }
//     template<typename I, typename P> I& first(I& i, const P& p) const { 
//       return graph->first(i, p); }

//     template<typename I> I getNext(const I& i) const { 
//       return graph->getNext(i); }
//     template<typename I> I& next(I &i) const { return graph->next(i); }    

//     template< typename It > It first() const { 
//       It e; first(e); return e; }

//     template< typename It > It first(const Node& v) const { 
//       It e; first(e, v); return e; }

//     Node target(const Edge& e) const { return graph->source(e); }
//     Node source(const Edge& e) const { return graph->target(e); }
  
//     template<typename I> bool valid(const I& i) const 
//       { return graph->valid(i); }
  
//     //template<typename I> void setInvalid(const I &i);
//     //{ return graph->setInvalid(i); }
  
//     template<typename I> Node aNode(const I& e) const { 
//       return graph->aNode(e); }
//     template<typename I> Node bNode(const I& e) const { 
//       return graph->bNode(e); }

//     Node addNode() const { return graph->addNode(); }
//     Edge addEdge(const Node& source, const Node& target) const { 
//       return graph->addEdge(source, target); }
  
//     int nodeNum() const { return graph->nodeNum(); }
//     int edgeNum() const { return graph->edgeNum(); }
  
//     template<typename I> void erase(const I& i) const { graph->erase(i); }
  
//     void clear() const { graph->clear(); }

//     template<typename T> class NodeMap : public Graph::NodeMap<T> { 
//     public:
//       NodeMap(const RevGraphWrapper<Graph>& _G) : 
// 	Graph::NodeMap<T>(_G.getGraph()) { }
//       NodeMap(const RevGraphWrapper<Graph>& _G, T a) : 
// 	Graph::NodeMap<T>(_G.getGraph(), a) { }
//     };

//     template<typename T> class EdgeMap : public Graph::EdgeMap<T> { 
//     public:
//       EdgeMap(const RevGraphWrapper<Graph>& _G) : 
// 	Graph::EdgeMap<T>(_G.getGraph()) { }
//       EdgeMap(const RevGraphWrapper<Graph>& _G, T a) : 
// 	Graph::EdgeMap<T>(_G.getGraph(), a) { }
//     };
//   };


  template<typename Graph>
  class RevGraphWrapper : public GraphWrapper<Graph> {
  public:
    typedef typename GraphWrapper<Graph>::Node Node;
    typedef typename GraphWrapper<Graph>::Edge Edge;
    //FIXME 
    //If Graph::OutEdgeIt is not defined
    //and we do not want to use RevGraphWrapper::InEdgeIt,
    //this won't work, because of typedef
    //OR
    //graphs have to define their non-existing iterators to void
    //Unfortunately all the typedefs are instantiated in templates, 
    //unlike other stuff
    typedef typename GraphWrapper<Graph>::OutEdgeIt InEdgeIt;
    typedef typename GraphWrapper<Graph>::InEdgeIt OutEdgeIt;

//     RevGraphWrapper() : GraphWrapper<Graph>() { }
    RevGraphWrapper(Graph& _graph) : GraphWrapper<Graph>(_graph) { }  

    Node target(const Edge& e) const 
      { return GraphWrapper<Graph>::source(e); }
    Node source(const Edge& e) const 
      { return GraphWrapper<Graph>::target(e); }
  };

  //Subgraph on the same node-set and partial edge-set
  template<typename Graph, typename EdgeFilterMap>
  class SubGraphWrapper : public GraphWrapper<Graph> {
  protected:
    EdgeFilterMap* filter_map;
  public:
    typedef typename GraphWrapper<Graph>::Node Node;
    typedef typename GraphWrapper<Graph>::NodeIt NodeIt;
    typedef typename GraphWrapper<Graph>::Edge Edge;
    typedef typename GraphWrapper<Graph>::EdgeIt EdgeIt;
    typedef typename GraphWrapper<Graph>::InEdgeIt InEdgeIt;
    typedef typename GraphWrapper<Graph>::OutEdgeIt OutEdgeIt;

//     SubGraphWrapper() : GraphWrapper<Graph>(), filter_map(0) { }
    SubGraphWrapper(Graph& _graph, EdgeFilterMap& _filter_map) : 
      GraphWrapper<Graph>(_graph), filter_map(&_filter_map) { }  

    template<typename I> I& first(I& i) const { 
      graph->first(i); 
      while (graph->valid(i) && !filter_map->get(i)) { graph->next(i); }
      return i;
    }
    template<typename I, typename P> I& first(I& i, const P& p) const { 
      graph->first(i, p); 
      while (graph->valid(i) && !filter_map->get(i)) { graph->next(i); }
      return i;
    }
    
    //template<typename I> I getNext(const I& i) const { 
    //  return gw.getNext(i); 
    //}
    template<typename I> I& next(I &i) const { 
      graph->next(i); 
      while (graph->valid(i) && !filter_map->get(i)) { graph->next(i); }
      return i;
    }
    
    template< typename It > It first() const { 
      It e; this->first(e); return e; }
    
    template< typename It > It first(const Node& v) const { 
      It e; this->first(e, v); return e; }
  };

//   template<typename GraphWrapper>
//   class UndirGraphWrapper {
//   protected:
//     //Graph* graph;
//     GraphWrapper gw;

//   public:
//     typedef GraphWrapper BaseGraph;

//     typedef typename GraphWrapper::Node Node;
//     typedef typename GraphWrapper::NodeIt NodeIt;

//     //typedef typename Graph::Edge Edge;
//     //typedef typename Graph::OutEdgeIt OutEdgeIt;
//     //typedef typename Graph::InEdgeIt InEdgeIt;
//     //typedef typename Graph::SymEdgeIt SymEdgeIt;
//     //typedef typename Graph::EdgeIt EdgeIt;

//     //private:
//     typedef typename GraphWrapper::Edge GraphEdge;
//     typedef typename GraphWrapper::OutEdgeIt GraphOutEdgeIt;
//     typedef typename GraphWrapper::InEdgeIt GraphInEdgeIt;
//     //public:

//     //UndirGraphWrapper() : graph(0) { }
//     UndirGraphWrapper(GraphWrapper _gw) : gw(_gw) { }

//     //void setGraph(Graph& _graph) { graph = &_graph; }
//     //Graph& getGraph() const { return (*graph); }
  
//     class Edge {
//       friend class UndirGraphWrapper<GraphWrapper>;
//       bool out_or_in; //true iff out
//       GraphOutEdgeIt out;
//       GraphInEdgeIt in;
//     public:
//       Edge() : out_or_in(), out(), in() { }
//       Edge(const Invalid& i) : out_or_in(false), out(), in(i) { }
//       operator GraphEdge() const {
// 	if (out_or_in) return(out); else return(in);
//       }
//       friend bool operator==(const Edge& u, const Edge& v) { 
// 	if (v.out_or_in) 
// 	  return (u.out_or_in && u.out==v.out);
// 	else
// 	  return (!u.out_or_in && u.in==v.in);
//       } 
//       friend bool operator!=(const Edge& u, const Edge& v) { 
// 	if (v.out_or_in) 
// 	  return (!u.out_or_in || u.out!=v.out);
// 	else
// 	  return (u.out_or_in || u.in!=v.in);
//       } 
//     };

//     class OutEdgeIt : public Edge {
//       friend class UndirGraphWrapper<GraphWrapper>;
//     public:
//       OutEdgeIt() : Edge() { }
//       OutEdgeIt(const Invalid& i) : Edge(i) { }
//       OutEdgeIt(const UndirGraphWrapper<GraphWrapper>& _G, const Node& n) 
// 	: Edge() { 
// 	out_or_in=true;
// 	_G.gw.first(out, n);
// 	if (!(_G.gw.valid(out))) {
// 	  out_or_in=false;
// 	  _G.gw.first(in, n);
// 	}
//       }
//     };

//     OutEdgeIt& first(OutEdgeIt& e, const Node& n) const {
//       e.out_or_in=true;
//       gw.first(e.out, n);
//       if (!(gw.valid(e.out))) {
// 	e.out_or_in=false;
// 	gw.first(e.in, n);
//       }
//       return e;
//     }

//     OutEdgeIt& next(OutEdgeIt& e) const {
//       if (e.out_or_in) {
// 	Node n=gw.source(e.out);
// 	gw.next(e.out);
// 	if (!gw.valid(e.out)) {
// 	  e.out_or_in=false;
// 	  gw.first(e.in, n);
// 	}
//       } else {
// 	gw.next(e.in);
//       }
//       return e;
//     }

//     Node aNode(const OutEdgeIt& e) const { 
//       if (e.out_or_in) return gw.source(e); else return gw.target(e); }
//     Node bNode(const OutEdgeIt& e) const { 
//       if (e.out_or_in) return gw.target(e); else return gw.source(e); }

//     typedef OutEdgeIt InEdgeIt; 

//     template<typename I> I& first(I& i) const { return gw.first(i); }
// //     template<typename I, typename P> I& first(I& i, const P& p) const { 
// //       return graph->first(i, p); }
    
//     template<typename I> I getNext(const I& i) const { 
//       return gw.getNext(i); }
//     template<typename I> I& next(I &i) const { return gw.next(i); }    

//     template< typename It > It first() const { 
//       It e; first(e); return e; }

//     template< typename It > It first(const Node& v) const { 
//       It e; first(e, v); return e; }

//     Node target(const Edge& e) const { return gw.target(e); }
//     Node source(const Edge& e) const { return gw.source(e); }

//     template<typename I> bool valid(const I& i) const 
//       { return gw.valid(i); }
  
//     //template<typename I> void setInvalid(const I &i);
//     //{ return graph->setInvalid(i); }

//     int nodeNum() const { return gw.nodeNum(); }
//     int edgeNum() const { return gw.edgeNum(); }
  
// //     template<typename I> Node aNode(const I& e) const { 
// //       return graph->aNode(e); }
// //     template<typename I> Node bNode(const I& e) const { 
// //       return graph->bNode(e); }
  
//     Node addNode() const { return gw.addNode(); }
// // FIXME: ez igy nem jo, mert nem
// //    Edge addEdge(const Node& source, const Node& target) const { 
// //      return graph->addEdge(source, target); }
  
//     template<typename I> void erase(const I& i) const { gw.erase(i); }
  
//     void clear() const { gw.clear(); }
    
//     template<typename T> class NodeMap : public GraphWrapper::NodeMap<T> { 
//     public:
//       NodeMap(const UndirGraphWrapper<GraphWrapper>& _G) : 
// 	GraphWrapper::NodeMap<T>(_G.gw) { }
//       NodeMap(const UndirGraphWrapper<GraphWrapper>& _G, T a) : 
// 	GraphWrapper::NodeMap<T>(_G.gw, a) { }
//     };

//     template<typename T> class EdgeMap : public GraphWrapper::EdgeMap<T> { 
//     public:
//       EdgeMap(const UndirGraphWrapper<GraphWrapper>& _G) : 
// 	GraphWrapper::EdgeMap<T>(_G.gw) { }
//       EdgeMap(const UndirGraphWrapper<GraphWrapper>& _G, T a) : 
// 	GraphWrapper::EdgeMap<T>(_G.gw, a) { }
//     };
//   };


  template<typename Graph>
  class UndirGraphWrapper : public GraphWrapper<Graph> {
  protected:
    typedef typename Graph::Edge GraphEdge;
    typedef typename Graph::OutEdgeIt GraphOutEdgeIt;
    typedef typename Graph::InEdgeIt GraphInEdgeIt;    
  public:
    typedef typename GraphWrapper<Graph>::Node Node;
    typedef typename GraphWrapper<Graph>::NodeIt NodeIt;

//     UndirGraphWrapper() : GraphWrapper<Graph>() { }
    UndirGraphWrapper(Graph& _graph) : GraphWrapper<Graph>(_graph) { }  

    class Edge {
      friend class UndirGraphWrapper<Graph>;
    protected:
      bool out_or_in; //true iff out
      GraphOutEdgeIt out;
      GraphInEdgeIt in;
    public:
      Edge() : out_or_in(), out(), in() { }
      Edge(const Invalid& i) : out_or_in(false), out(), in(i) { }
      operator GraphEdge() const {
	if (out_or_in) return(out); else return(in);
      }
//FIXME
//2 edges are equal if they "refer" to the same physical edge 
//is it good?
      friend bool operator==(const Edge& u, const Edge& v) { 
	if (v.out_or_in) 
	  if (u.out_or_in) return (u.out==v.out); else return (u.out==v.in);
	//return (u.out_or_in && u.out==v.out);
	else
	  if (u.out_or_in) return (u.out==v.in); else return (u.in==v.in);
	//return (!u.out_or_in && u.in==v.in);
      } 
      friend bool operator!=(const Edge& u, const Edge& v) { 
	if (v.out_or_in) 
	  if (u.out_or_in) return (u.out!=v.out); else return (u.out!=v.in);
	//return (!u.out_or_in || u.out!=v.out);
	else
	  if (u.out_or_in) return (u.out!=v.in); else return (u.in!=v.in);
	//return (u.out_or_in || u.in!=v.in);
      } 
    };

    class OutEdgeIt : public Edge {
      friend class UndirGraphWrapper<Graph>;
    public:
      OutEdgeIt() : Edge() { }
      OutEdgeIt(const Invalid& i) : Edge(i) { }
      OutEdgeIt(const UndirGraphWrapper<Graph>& _G, const Node& n) 
	: Edge() { 
	out_or_in=true; _G.graph->first(out, n);
	if (!(_G.graph->valid(out))) { out_or_in=false; _G.graph->first(in, n);	}
      }
    };

    typedef OutEdgeIt InEdgeIt; 

    class EdgeIt : public Edge {
      friend class UndirGraphWrapper<Graph>;
    protected:
      NodeIt v;
    public:
      EdgeIt() : Edge() { }
      EdgeIt(const Invalid& i) : Edge(i) { }
      EdgeIt(const UndirGraphWrapper<Graph>& _G) 
	: Edge() { 
	out_or_in=true;
	//Node v;
	_G.first(v);
	if (_G.valid(v)) _G.graph->first(out); else out=INVALID;
	while (_G.valid(v) && !_G.graph->valid(out)) { 
	  _G.graph->next(v); 
	  if (_G.valid(v)) _G.graph->first(out); 
	}
      }
    };

    OutEdgeIt& first(OutEdgeIt& e, const Node& n) const {
      e.out_or_in=true; graph->first(e.out, n);
      if (!(graph->valid(e.out))) { e.out_or_in=false; graph->first(e.in, n); }
      return e;
    }

    EdgeIt& first(EdgeIt& e) const {
      e.out_or_in=true;
      //NodeIt v;
      first(e.v);
      if (valid(e.v)) graph->first(e.out, e.v); else e.out=INVALID;
      while (valid(e.v) && !graph->valid(e.out)) { 
	graph->next(e.v); 
	if (valid(e.v)) graph->first(e.out, e.v); 
      }
      return e;
    }

    template<typename I> I& first(I& i) const { graph->first(i); return i; }
    template<typename I, typename P> I& first(I& i, const P& p) const { 
      graph->first(i, p); return i; }

    OutEdgeIt& next(OutEdgeIt& e) const {
      if (e.out_or_in) {
	Node n=graph->source(e.out);
	graph->next(e.out);
	if (!graph->valid(e.out)) { e.out_or_in=false; graph->first(e.in, n); }
      } else {
	graph->next(e.in);
      }
      return e;
    }

    EdgeIt& next(EdgeIt& e) const {
      //NodeIt v=source(e);
      graph->next(e.out);
      while (valid(e.v) && !graph->valid(e.out)) { 
	next(e.v); 
	if (valid(e.v)) graph->first(e.out, e.v); 
      }
      return e;
    }

    template<typename I> I& next(I &i) const { return graph->next(i); }    
//    template<typename I> I getNext(const I& i) const { return gw.getNext(i); }

    template< typename It > It first() const { 
      It e; this->first(e); return e; }

    template< typename It > It first(const Node& v) const { 
      It e; this->first(e, v); return e; }

//    Node target(const Edge& e) const { return gw.target(e); }
//    Node source(const Edge& e) const { return gw.source(e); }

//    template<typename I> bool valid(const I& i) const 
//      { return gw.valid(i); }
  
//    int nodeNum() const { return gw.nodeNum(); }
//    int edgeNum() const { return gw.edgeNum(); }
  
//     template<typename I> Node aNode(const I& e) const { 
//       return graph->aNode(e); }
//     template<typename I> Node bNode(const I& e) const { 
//       return graph->bNode(e); }

    Node aNode(const OutEdgeIt& e) const { 
      if (e.out_or_in) return graph->source(e); else return graph->target(e); }
    Node bNode(const OutEdgeIt& e) const { 
      if (e.out_or_in) return graph->target(e); else return graph->source(e); }
  
//    Node addNode() const { return gw.addNode(); }

// FIXME: ez igy nem jo, mert nem
//    Edge addEdge(const Node& source, const Node& target) const { 
//      return graph->addEdge(source, target); }
  
//    template<typename I> void erase(const I& i) const { gw.erase(i); }
  
//    void clear() const { gw.clear(); }
    
//     template<typename T> class NodeMap : public Graph::NodeMap<T> { 
//     public:
//       NodeMap(const UndirGraphWrapper<Graph>& _G) : 
// 	Graph::NodeMap<T>(_G.gw) { }
//       NodeMap(const UndirGraphWrapper<Graph>& _G, T a) : 
// 	Graph::NodeMap<T>(_G.gw, a) { }
//     };

//     template<typename T> class EdgeMap : 
//       public GraphWrapper<Graph>::EdgeMap<T> { 
//     public:
//       EdgeMap(const UndirGraphWrapper<Graph>& _G) : 
// 	GraphWrapper<Graph>::EdgeMap<T>(_G.gw) { }
//       EdgeMap(const UndirGraphWrapper<Graph>& _G, T a) : 
// 	Graph::EdgeMap<T>(_G.gw, a) { }
//     };
   };





//   template<typename Graph>
//   class SymGraphWrapper
//   {
//     Graph* graph;
  
//   public:
//     typedef Graph BaseGraph;

//     typedef typename Graph::Node Node;
//     typedef typename Graph::Edge Edge;
  
//     typedef typename Graph::NodeIt NodeIt;
    
//     //FIXME tag-ekkel megcsinalni, hogy abbol csinaljon
//     //iranyitatlant, ami van
//     //mert csak 1 dolgot lehet be typedef-elni
//     typedef typename Graph::OutEdgeIt SymEdgeIt;
//     //typedef typename Graph::InEdgeIt SymEdgeIt;
//     //typedef typename Graph::SymEdgeIt SymEdgeIt;
//     typedef typename Graph::EdgeIt EdgeIt;

//     int nodeNum() const { return graph->nodeNum(); }
//     int edgeNum() const { return graph->edgeNum(); }
    
//     template<typename I> I& first(I& i) const { return graph->first(i); }
//     template<typename I, typename P> I& first(I& i, const P& p) const { 
//       return graph->first(i, p); }
//     //template<typename I> I next(const I i); { return graph->goNext(i); }
//     //template<typename I> I &goNext(I &i); { return graph->goNext(i); }

//     template< typename It > It first() const { 
//       It e; first(e); return e; }

//     template< typename It > It first(Node v) const { 
//       It e; first(e, v); return e; }

//     Node target(const Edge& e) const { return graph->target(e); }
//     Node source(const Edge& e) const { return graph->source(e); }
  
//     template<typename I> Node aNode(const I& e) const { 
//       return graph->aNode(e); }
//     template<typename I> Node bNode(const I& e) const { 
//       return graph->bNode(e); }
  
//     //template<typename I> bool valid(const I i);
//     //{ return graph->valid(i); }
  
//     //template<typename I> void setInvalid(const I &i);
//     //{ return graph->setInvalid(i); }
  
//     Node addNode() { return graph->addNode(); }
//     Edge addEdge(const Node& source, const Node& target) { 
//       return graph->addEdge(source, target); }
  
//     template<typename I> void erase(const I& i) { graph->erase(i); }
  
//     void clear() { graph->clear(); }
  
//     template<typename T> class NodeMap : public Graph::NodeMap<T> { };
//     template<typename T> class EdgeMap : public Graph::EdgeMap<T> { };
  
//     void setGraph(Graph& _graph) { graph = &_graph; }
//     Graph& getGraph() { return (*graph); }

//     //SymGraphWrapper() : graph(0) { }
//     SymGraphWrapper(Graph& _graph) : graph(&_graph) { }
//   };


  template<typename Graph, typename Number, typename FlowMap, typename CapacityMap>
  class ResGraphWrapper : public GraphWrapper<Graph>{
  public:
    typedef typename GraphWrapper<Graph>::Node Node;
    typedef typename GraphWrapper<Graph>::NodeIt NodeIt;
  protected:
    typedef typename Graph::OutEdgeIt OldOutEdgeIt;
    typedef typename Graph::InEdgeIt OldInEdgeIt;
    FlowMap* flow;
    const CapacityMap* capacity;
  public:

    ResGraphWrapper(Graph& _graph, FlowMap& _flow, 
		    const CapacityMap& _capacity) : 
      GraphWrapper<Graph>(_graph), flow(&_flow), capacity(&_capacity) { }

    class Edge; 
    class OutEdgeIt; 
    friend class Edge; 
    friend class OutEdgeIt; 

    class Edge {
      friend class ResGraphWrapper<Graph, Number, FlowMap, CapacityMap>;
    protected:
      bool out_or_in; //true, iff out
      OldOutEdgeIt out;
      OldInEdgeIt in;
    public:
      Edge() : out_or_in(true) { } 
      Edge(const Invalid& i) : out_or_in(false), out(), in(i) { }
//       bool valid() const { 
// 	return out_or_in && out.valid() || in.valid(); }
      friend bool operator==(const Edge& u, const Edge& v) { 
	if (v.out_or_in) 
	  return (u.out_or_in && u.out==v.out);
	else
	  return (!u.out_or_in && u.in==v.in);
      } 
      friend bool operator!=(const Edge& u, const Edge& v) { 
	if (v.out_or_in) 
	  return (!u.out_or_in || u.out!=v.out);
	else
	  return (u.out_or_in || u.in!=v.in);
      } 
    };


    class OutEdgeIt : public Edge {
      friend class ResGraphWrapper<Graph, Number, FlowMap, CapacityMap>;
    public:
      OutEdgeIt() { }
      //FIXME
      OutEdgeIt(const Edge& e) : Edge(e) { }
      OutEdgeIt(const Invalid& i) : Edge(i) { }
    protected:
      OutEdgeIt(const ResGraphWrapper<Graph, Number, FlowMap, CapacityMap>& resG, Node v) : Edge() { 
	resG.graph->first(out, v);
	while( resG.graph->valid(out) && !(resG.resCap(out)>0) ) { resG.graph->next(out); }
	if (!resG.graph->valid(out)) {
	  out_or_in=0;
	  resG.graph->first(in, v);
	  while( resG.graph->valid(in) && !(resG.resCap(in)>0) ) { resG.graph->next(in); }
	}
      }
//     public:
//       OutEdgeIt& operator++() { 
// 	if (out_or_in) {
// 	  Node v=/*resG->*/G->aNode(out);
// 	  ++out;
// 	  while( out.valid() && !(Edge::resCap()>0) ) { ++out; }
// 	  if (!out.valid()) {
// 	    out_or_in=0;
// 	    G->first(in, v); 
// 	    while( in.valid() && !(Edge::resCap()>0) ) { ++in; }
// 	  }
// 	} else {
// 	  ++in;
// 	  while( in.valid() && !(Edge::resCap()>0) ) { ++in; } 
// 	}
// 	return *this; 
//       }
    };

    //FIXME This is just for having InEdgeIt
    typedef void InEdgeIt;

    class EdgeIt : public Edge {
      friend class ResGraphWrapper<Graph, Number, FlowMap, CapacityMap>;
      NodeIt v; 
    public:
      EdgeIt() { }
      //EdgeIt(const EdgeIt& e) : Edge(e), v(e.v) { }
      EdgeIt(const Invalid& i) : Edge(i) { }
      EdgeIt(const ResGraphWrapper<Graph, Number, FlowMap, CapacityMap>& resG) : Edge() { 
	resG.graph->first(v);
	if (resG.graph->valid(v)) resG.graph->first(out, v); else out=INVALID;
	while (resG.graph->valid(out) && !(resG.resCap(out)>0) ) { resG.graph->next(out); }
	while (resG.graph->valid(v) && !resG.graph->valid(out)) { 
	  resG.graph->next(v); 
	  if (resG.graph->valid(v)) resG.graph->first(out, v); 
	  while (resG.graph->valid(out) && !(resG.resCap(out)>0) ) { resG.graph->next(out); }
	}
	if (!resG.graph->valid(out)) {
	  out_or_in=0;
	  resG.graph->first(v);
	  if (resG.graph->valid(v)) resG.graph->first(in, v); else in=INVALID;
	  while (resG.graph->valid(in) && !(resG.resCap(in)>0) ) { resG.graph->next(in); }
	  while (resG.graph->valid(v) && !resG.graph->valid(in)) { 
	    resG.graph->next(v); 
	    if (resG.graph->valid(v)) resG.graph->first(in, v); 
	    while (resG.graph->valid(in) && !(resG.resCap(in)>0) ) { resG.graph->next(in); }
	  }
	}
      }
//       EdgeIt& operator++() { 
// 	if (out_or_in) {
// 	  ++out;
// 	  while (out.valid() && !(Edge::resCap()>0) ) { ++out; }
// 	  while (v.valid() && !out.valid()) { 
// 	    ++v; 
// 	    if (v.valid()) G->first(out, v); 
// 	    while (out.valid() && !(Edge::resCap()>0) ) { ++out; }
// 	  }
// 	  if (!out.valid()) {
// 	    out_or_in=0;
// 	    G->first(v);
// 	    if (v.valid()) G->first(in, v); else in=OldInEdgeIt();
// 	    while (in.valid() && !(Edge::resCap()>0) ) { ++in; }
// 	    while (v.valid() && !in.valid()) { 
// 	      ++v; 
// 	      if (v.valid()) G->first(in, v); 
// 	      while (in.valid() && !(Edge::resCap()>0) ) { ++in; }
// 	    }  
// 	  }
// 	} else {
// 	  ++in;
// 	  while (in.valid() && !(Edge::resCap()>0) ) { ++in; }
// 	  while (v.valid() && !in.valid()) { 
// 	    ++v; 
// 	    if (v.valid()) G->first(in, v); 
// 	    while (in.valid() && !(Edge::resCap()>0) ) { ++in; }
// 	  }
// 	}
// 	return *this;
//       }
    };

    NodeIt& first(NodeIt& v) const { graph->first(v); return v; }
    OutEdgeIt& first(OutEdgeIt& e, Node v) const { 
      e=OutEdgeIt(*this, v); 
      return e;
    }
    EdgeIt& first(EdgeIt& e) const { 
      e=EdgeIt(*this); 
      return e;
    }
   
    NodeIt& next(NodeIt& n) const { return graph->next(n); }

    OutEdgeIt& next(OutEdgeIt& e) const { 
      if (e.out_or_in) {
	Node v=graph->aNode(e.out);
	graph->next(e.out);
	while( graph->valid(e.out) && !(resCap(e.out)>0) ) { graph->next(e.out); }
	if (!graph->valid(e.out)) {
	  e.out_or_in=0;
	  graph->first(e.in, v); 
	  while( graph->valid(e.in) && !(resCap(e.in)>0) ) { graph->next(e.in); }
	}
      } else {
	graph->next(e.in);
	while( graph->valid(e.in) && !(resCap(e.in)>0) ) { graph->next(e.in); } 
      }
      return e;
    }

    EdgeIt& next(EdgeIt& e) const { 
      if (e.out_or_in) {
	graph->next(e.out);
	while (graph->valid(e.out) && !(resCap(e.out)>0) ) { graph->next(e.out); }
	  while (graph->valid(e.v) && !graph->valid(e.out)) { 
	    graph->next(e.v); 
	    if (graph->valid(e.v)) graph->first(e.out, e.v); 
	    while (graph->valid(e.out) && !(resCap(e.out)>0) ) { graph->next(e.out); }
	  }
	  if (!graph->valid(e.out)) {
	    e.out_or_in=0;
	    graph->first(e.v);
	    if (graph->valid(e.v)) graph->first(e.in, e.v); else e.in=INVALID;
	    while (graph->valid(e.in) && !(resCap(e.in)>0) ) { graph->next(e.in); }
	    while (graph->valid(e.v) && !graph->valid(e.in)) { 
	      graph->next(e.v); 
	      if (graph->valid(e.v)) graph->first(e.in, e.v); 
	      while (graph->valid(e.in) && !(resCap(e.in)>0) ) { graph->next(e.in); }
	    }  
	  }
	} else {
	  graph->next(e.in);
	  while (graph->valid(e.in) && !(resCap(e.in)>0) ) { graph->next(e.in); }
	  while (graph->valid(e.v) && !graph->valid(e.in)) { 
	    graph->next(e.v); 
	    if (graph->valid(e.v)) graph->first(e.in, e.v); 
	    while (graph->valid(e.in) && !(resCap(e.in)>0) ) { graph->next(e.in); }
	  }
	}
	return e;
      }
    

    template< typename It >
    It first() const { 
      It e;
      first(e);
      return e; 
    }

    template< typename It >
    It first(Node v) const { 
      It e;
      first(e, v);
      return e; 
    }

    Node source(Edge e) const { 
      return ((e.out_or_in) ? graph->aNode(e.out) : graph->aNode(e.in)); }
    Node target(Edge e) const { 
      return ((e.out_or_in) ? graph->bNode(e.out) : graph->bNode(e.in)); }

    Node aNode(OutEdgeIt e) const { 
      return ((e.out_or_in) ? graph->aNode(e.out) : graph->aNode(e.in)); }
    Node bNode(OutEdgeIt e) const { 
      return ((e.out_or_in) ? graph->bNode(e.out) : graph->bNode(e.in)); }

    int nodeNum() const { return graph->nodeNum(); }
    //FIXME
    //int edgeNum() const { return graph->edgeNum(); }


    int id(Node v) const { return graph->id(v); }

    bool valid(Node n) const { return graph->valid(n); }
    bool valid(Edge e) const { 
      return e.out_or_in ? graph->valid(e.out) : graph->valid(e.in); }

    void augment(const Edge& e, Number a) const {
      if (e.out_or_in)  
	flow->set(e.out, flow->get(e.out)+a);
      else  
	flow->set(e.in, flow->get(e.in)-a);
    }

    Number resCap(const Edge& e) const { 
      if (e.out_or_in) 
	return (capacity->get(e.out)-flow->get(e.out)); 
      else 
	return (flow->get(e.in)); 
    }

    Number resCap(OldOutEdgeIt out) const { 
      return (capacity->get(out)-flow->get(out)); 
    }
    
    Number resCap(OldInEdgeIt in) const { 
      return (flow->get(in)); 
    }

//     template<typename T> class NodeMap : public Graph::NodeMap<T> { 
//     public:
//       NodeMap(const ResGraphWrapper<Graph, Number, FlowMap, CapacityMap>& _G) 
// 	: Graph::NodeMap<T>(_G.gw) { }
//       NodeMap(const ResGraphWrapper<Graph, Number, FlowMap, CapacityMap>& _G, 
// 	      T a) : Graph::NodeMap<T>(_G.gw, a) { }
//     };

//     template <typename T>
//     class NodeMap {
//       typename Graph::NodeMap<T> node_map; 
//     public:
//       NodeMap(const ResGraphWrapper<Graph, Number, FlowMap, CapacityMap>& _G) : node_map(*(_G.graph)) { }
//       NodeMap(const ResGraphWrapper<Graph, Number, FlowMap, CapacityMap>& _G, T a) : node_map(*(_G.graph), a) { }
//       void set(Node nit, T a) { node_map.set(nit, a); }
//       T get(Node nit) const { return node_map.get(nit); }
//     };

    template <typename T>
    class EdgeMap {
      typename Graph::EdgeMap<T> forward_map, backward_map; 
    public:
      EdgeMap(const ResGraphWrapper<Graph, Number, FlowMap, CapacityMap>& _G) : forward_map(*(_G.graph)), backward_map(*(_G.graph)) { }
      EdgeMap(const ResGraphWrapper<Graph, Number, FlowMap, CapacityMap>& _G, T a) : forward_map(*(_G.graph), a), backward_map(*(_G.graph), a) { }
      void set(Edge e, T a) { 
	if (e.out_or_in) 
	  forward_map.set(e.out, a); 
	else 
	  backward_map.set(e.in, a); 
      }
      T get(Edge e) { 
	if (e.out_or_in) 
	  return forward_map.get(e.out); 
	else 
	  return backward_map.get(e.in); 
      }
    };
  };

  //ErasingFirstGraphWrapper for blocking flows
  template<typename Graph, typename FirstOutEdgesMap>
  class ErasingFirstGraphWrapper : public GraphWrapper<Graph> {
  protected:
    FirstOutEdgesMap* first_out_edges;
  public:
    typedef typename GraphWrapper<Graph>::Node Node;
    typedef typename GraphWrapper<Graph>::NodeIt NodeIt;
    typedef typename GraphWrapper<Graph>::Edge Edge;
    typedef typename GraphWrapper<Graph>::EdgeIt EdgeIt;
    typedef typename GraphWrapper<Graph>::InEdgeIt InEdgeIt;
    typedef typename GraphWrapper<Graph>::OutEdgeIt OutEdgeIt;

    ErasingFirstGraphWrapper(Graph& _graph, 
			     FirstOutEdgesMap& _first_out_edges) : 
      GraphWrapper<Graph>(_graph), first_out_edges(&_first_out_edges) { }  

    template<typename I> I& first(I& i) const { 
      graph->first(i); 
      return i;
    }
    OutEdgeIt& first(OutEdgeIt& e, const Node& n) const {
      e=first_out_edges->get(n);
      return e;
    }
    template<typename I, typename P> I& first(I& i, const P& p) const { 
      graph->first(i, p); 
      return i;
    }
    
    //template<typename I> I getNext(const I& i) const { 
    //  return gw.getNext(i); 
    //}
    template<typename I> I& next(I &i) const { 
      graph->next(i); 
      return i;
    }
    
    template< typename It > It first() const { 
      It e; this->first(e); return e; }
    
    template< typename It > It first(const Node& v) const { 
      It e; this->first(e, v); return e; }

    void erase(const OutEdgeIt& e) const {
      OutEdgeIt f=e;
      this->next(f);
      first_out_edges->set(this->source(e), f);
    }
  };

// // FIXME: comparison should be made better!!!
//   template<typename Graph, typename T, typename LowerMap, typename FlowMap, typename UpperMap>
//   class ResGraphWrapper
//   {
//     Graph* graph;
  
//   public:
//     typedef Graph BaseGraph;

//     typedef typename Graph::Node Node;
//     typedef typename Graph::Edge Edge;
  
//     typedef typename Graph::NodeIt NodeIt;
   
//     class OutEdgeIt {
//     public:
//       //Graph::Node n;
//       bool out_or_in;
//       typename Graph::OutEdgeIt o;
//       typename Graph::InEdgeIt i;   
//     };
//     class InEdgeIt {
//     public:
//       //Graph::Node n;
//       bool out_or_in;
//       typename Graph::OutEdgeIt o;
//       typename Graph::InEdgeIt i;   
//     };
//     typedef typename Graph::SymEdgeIt SymEdgeIt;
//     typedef typename Graph::EdgeIt EdgeIt;

//     int nodeNum() const { return gw.nodeNum(); }
//     int edgeNum() const { return gw.edgeNum(); }

//     Node& first(Node& n) const { return gw.first(n); }

//     // Edge and SymEdge  is missing!!!!
//     // Edge <-> In/OutEdgeIt conversion is missing!!!!

//     //FIXME
//     OutEdgeIt& first(OutEdgeIt& e, const Node& n) const 
//       {
// 	e.n=n;
// 	gw.first(e.o,n);
// 	while(gw.valid(e.o) && fmap.get(e.o)>=himap.get(e.o))
// 	  gw.goNext(e.o);
// 	if(!gw.valid(e.o)) {
// 	  gw.first(e.i,n);
// 	  while(gw.valid(e.i) && fmap.get(e.i)<=lomap.get(e.i))
// 	    gw.goNext(e.i);
// 	}
// 	return e;
//       }
// /*
//   OutEdgeIt &goNext(OutEdgeIt &e)
//   {
//   if(gw.valid(e.o)) {
//   while(gw.valid(e.o) && fmap.get(e.o)>=himap.get(e.o))
//   gw.goNext(e.o);
//   if(gw.valid(e.o)) return e;
//   else gw.first(e.i,e.n);
//   }
//   else {
//   while(gw.valid(e.i) && fmap.get(e.i)<=lomap.get(e.i))
//   gw.goNext(e.i);
//   return e;
//   }
//   }
//   OutEdgeIt Next(const OutEdgeIt &e) {OutEdgeIt t(e); return goNext(t);}
// */
//     //bool valid(const OutEdgeIt e) { return gw.valid(e.o)||gw.valid(e.i);}

//     //FIXME
//     InEdgeIt& first(InEdgeIt& e, const Node& n) const 
//       {
// 	e.n=n;
// 	gw.first(e.i,n);
// 	while(gw.valid(e.i) && fmap.get(e.i)>=himap.get(e.i))
// 	  gw.goNext(e.i);
// 	if(!gw.valid(e.i)) {
// 	  gw.first(e.o,n);
// 	  while(gw.valid(e.o) && fmap.get(e.o)<=lomap.get(e.o))
// 	    gw.goNext(e.o);
// 	}
// 	return e;
//       }
// /*
//   InEdgeIt &goNext(InEdgeIt &e)
//   {
//   if(gw.valid(e.i)) {
//   while(gw.valid(e.i) && fmap.get(e.i)>=himap.get(e.i))
//   gw.goNext(e.i);
//   if(gw.valid(e.i)) return e;
//   else gw.first(e.o,e.n);
//   }
//   else {
//   while(gw.valid(e.o) && fmap.get(e.o)<=lomap.get(e.o))
//   gw.goNext(e.o);
//   return e;
//   }
//   }
//   InEdgeIt Next(const InEdgeIt &e) {InEdgeIt t(e); return goNext(t);}
// */
//     //bool valid(const InEdgeIt e) { return gw.valid(e.i)||gw.valid(e.o);}

//     //template<typename I> I &goNext(I &i); { return gw.goNext(i); }
//     //template<typename I> I next(const I i); { return gw.goNext(i); }

//     template< typename It > It first() const { 
//       It e; first(e); return e; }

//     template< typename It > It first(Node v) const { 
//       It e; first(e, v); return e; }

//     Node target(const Edge& e) const { return gw.target(e); }
//     Node source(const Edge& e) const { return gw.source(e); }
  
//     template<typename I> Node aNode(const I& e) const { 
//       return gw.aNode(e); }
//     template<typename I> Node bNode(const I& e) const { 
//       return gw.bNode(e); }
  
//     //template<typename I> bool valid(const I i);
//     //{ return gw.valid(i); }
  
//     //template<typename I> void setInvalid(const I &i);
//     //{ return gw.setInvalid(i); }
  
//     Node addNode() { return gw.addNode(); }
//     Edge addEdge(const Node& source, const Node& target) { 
//       return gw.addEdge(source, target); }
  
//     template<typename I> void erase(const I& i) { gw.erase(i); }
  
//     void clear() { gw.clear(); }
  
//     template<typename S> class NodeMap : public Graph::NodeMap<S> { };
//     template<typename S> class EdgeMap : public Graph::EdgeMap<S> { };
  
//     void setGraph(Graph& _graph) { graph = &_graph; }
//     Graph& getGraph() { return (*graph); }

//     //ResGraphWrapper() : graph(0) { }
//     ResGraphWrapper(Graph& _graph) : graph(&_graph) { }
//   };

} //namespace lemon

#endif //LEMON_GRAPH_WRAPPER_H

