#ifndef VECTOR_MAP_H
#define VECTOR_MAP_H

#include <vector>
#include <iostream>

#include "map_base.h"

namespace hugo {
	
	template <typename G, typename K, typename KIt>
	class VectorMapFactory {
	
	
	public:
		
		typedef G Graph;
		typedef K Key;
		typedef KIt KeyIt;
		
		template <typename V> 
		class VectorMap : public MapBase<G, K, KIt> {
		public:
			typedef V ValueType;
	
			VectorMap() {}
			
			VectorMap(Graph& g, MapRegistry<G, K, KIt>& r) 
				: MapBase<G, K, KIt>(g, r) {}
	
	
			ValueType& operator[](const K& key) {
				int id = graph->id(key);
				return container[id];
			} 
		
			const ValueType& operator[](const K& key) const {
				int id = graph->id(key);
				return container[id];
			}
	
			const ValueType& get(const K& key) const {
				int id = graph->id(key);
				return container[id];
			} 
		
			void set(const K& key, const ValueType& val) {
				int id = graph->id(key);
				container[id] = val;
			}
		
			void add(const K& key) {
				int id = graph->id(key);
				std::cerr << id << std::endl;
				if (id >= container.size()) {
					container.resize(id + 1);
				}
			}
		
			void erase(const K& key) {}
	
		private:
			typedef std::vector<ValueType> Container;
		
			Container container;
		};
		
	};
}

#endif
