/* -*- C++ -*-
 * src/lemon/demo/graph_to_eps.cc - 
 * Part of LEMON, a generic C++ optimization library
 *
 * Copyright (C) 2004 Egervary Jeno Kombinatorikus Optimalizalasi Kutatocsoport
 * (Egervary Combinatorial Optimization Research Group, EGRES).
 *
 * Permission to use, modify and distribute this software is granted
 * provided that this copyright notice appears in all copies. For
 * precise terms see the accompanying LICENSE file.
 *
 * This software is provided "AS IS" with no warranty of any kind,
 * express or implied, and with no claim as to its suitability for any
 * purpose.
 *
 */

#include<lemon/graph_to_eps.h>
#include<lemon/maps.h>
#include<lemon/list_graph.h>


using namespace std;
using namespace lemon;

class ColorSet : public MapBase<int,Color>
{
public:
  Color operator[](int i) const
  {
    switch(i%8){
    case 0: return Color(0,0,0);
    case 1: return Color(1,0,0);
    case 2: return Color(0,1,0);
    case 3: return Color(0,0,1);
    case 4: return Color(1,1,0);
    case 5: return Color(1,0,1);
    case 6: return Color(0,1,1);
    case 7: return Color(1,1,1);
    }
    return Color(0,0,0);
  }
} colorSet;

class IdMap :public MapBase<ListGraph::Node,int>
{
  const ListGraph &g;
public:
  IdMap(const ListGraph &_g) :g(_g) {}
  Value operator[](Key n) const { return g.id(n); }
};

int main()
{
  ListGraph g;
  typedef ListGraph::Node Node;
  typedef ListGraph::NodeIt NodeIt;
  typedef ListGraph::Edge Edge;
  typedef xy<int> Xy;
  
  Node n1=g.addNode();
  Node n2=g.addNode();
  Node n3=g.addNode();
  Node n4=g.addNode();
  Node n5=g.addNode();

  ListGraph::NodeMap<Xy> coords(g);
  ListGraph::NodeMap<double> sizes(g);
  ListGraph::NodeMap<int> colors(g);
  ListGraph::NodeMap<int> shapes(g);
  ListGraph::EdgeMap<int> ecolors(g);
  ListGraph::EdgeMap<int> widths(g);
  
  coords[n1]=Xy(50,50);  sizes[n1]=1; colors[n1]=1; shapes[n1]=0;
  coords[n2]=Xy(50,70);  sizes[n2]=2; colors[n2]=2; shapes[n2]=2;
  coords[n3]=Xy(70,70);  sizes[n3]=1; colors[n3]=3; shapes[n3]=0;
  coords[n4]=Xy(70,50);  sizes[n4]=2; colors[n4]=4; shapes[n4]=1;
  coords[n5]=Xy(85,60);  sizes[n5]=3; colors[n5]=5; shapes[n5]=2;
  
  Edge e;

  e=g.addEdge(n1,n2); ecolors[e]=0; widths[e]=1;
  e=g.addEdge(n2,n3); ecolors[e]=0; widths[e]=1;
  e=g.addEdge(n3,n5); ecolors[e]=0; widths[e]=3;
  e=g.addEdge(n5,n4); ecolors[e]=0; widths[e]=1;
  e=g.addEdge(n4,n1); ecolors[e]=0; widths[e]=1;
  e=g.addEdge(n2,n4); ecolors[e]=1; widths[e]=2;
  e=g.addEdge(n3,n4); ecolors[e]=2; widths[e]=1;
  
  IdMap id(g);

  graphToEps(g,"graph_to_eps_demo_out.eps").scale(10).coords(coords).
    nodeScale(2).nodeSizes(sizes).
    nodeShapes(shapes).
    nodeColors(composeMap(colorSet,colors)).
    edgeColors(composeMap(colorSet,ecolors)).
    edgeWidthScale(.4).edgeWidths(widths).
    nodeTexts(id).nodeTextSize(3).
    run();

  graphToEps(g,"graph_to_eps_demo_out_arr.eps").scale(10).
    nodeColors(composeMap(colorSet,colors)).
    coords(coords).
    nodeScale(2).nodeSizes(sizes).
    nodeShapes(shapes).
    edgeColors(composeMap(colorSet,ecolors)).
    edgeWidthScale(.4).edgeWidths(widths).
    nodeTexts(id).nodeTextSize(3).
    drawArrows().arrowWidth(1).arrowLength(1).
    run();

  e=g.addEdge(n1,n4); ecolors[e]=2; widths[e]=1;
  e=g.addEdge(n4,n1); ecolors[e]=1; widths[e]=2;

  e=g.addEdge(n1,n2); ecolors[e]=1; widths[e]=1;
  e=g.addEdge(n1,n2); ecolors[e]=2; widths[e]=1;
  e=g.addEdge(n1,n2); ecolors[e]=3; widths[e]=1;
  e=g.addEdge(n1,n2); ecolors[e]=4; widths[e]=1;
  e=g.addEdge(n1,n2); ecolors[e]=5; widths[e]=1;
  e=g.addEdge(n1,n2); ecolors[e]=6; widths[e]=1;
  e=g.addEdge(n1,n2); ecolors[e]=7; widths[e]=1;

  graphToEps(g,"graph_to_eps_demo_out_par.eps").scale(10).
    nodeShapes(shapes).
    coords(coords).
    nodeScale(2).nodeSizes(sizes).
    nodeColors(composeMap(colorSet,colors)).
    edgeColors(composeMap(colorSet,ecolors)).
    edgeWidthScale(.4).edgeWidths(widths).
    nodeTexts(id).nodeTextSize(3).
    enableParallel().parEdgeDist(1.5).
    run();
  
  graphToEps(g,"graph_to_eps_demo_out_par_arr.eps").scale(10).
    nodeScale(2).nodeSizes(sizes).
    coords(coords).
    nodeShapes(shapes).
    nodeColors(composeMap(colorSet,colors)).
    edgeColors(composeMap(colorSet,ecolors)).
    edgeWidthScale(.3).edgeWidths(widths).
    nodeTexts(id).nodeTextSize(3).
    enableParallel().parEdgeDist(1).
    drawArrows().arrowWidth(1).arrowLength(1).
    run();

  graphToEps(g,"graph_to_eps_demo_out_a4.eps").scaleToA4().
    nodeScale(2).nodeSizes(sizes).
    coords(coords).
    nodeShapes(shapes).
    nodeColors(composeMap(colorSet,colors)).
    edgeColors(composeMap(colorSet,ecolors)).
    edgeWidthScale(.3).edgeWidths(widths).
    nodeTexts(id).nodeTextSize(3).
    enableParallel().parEdgeDist(1).
    drawArrows().arrowWidth(1).arrowLength(1).
    run();

}
