// -*- c++ -*-
//compile it with 
//g++ -ansi -pedantic
//and with 
//g++
//I did with g++ ver 3.0.4, suse 8.0
//If the template is removed from NodeMap, then it works well.
//athos@cs.elte.hu
//klao@cs.elte.hu
//marci@cs.elte.hu

class ListGraph {
public:
  ListGraph() { }

  template <typename T> class NodeMap {
    const ListGraph& G; 
  public:
    NodeMap(const ListGraph& _G) : G(_G) { }
  };

};

template<typename Graph> class GraphWrapper {
protected:
  Graph* graph;
public:
  GraphWrapper(Graph& _graph) : graph(&_graph) { }
 
  template<typename T> class NodeMap : public Graph::template NodeMap<T> { 
    typedef typename Graph::template NodeMap<T> Parent;
  public:
    NodeMap(const GraphWrapper<Graph>& _G) :  
      Parent(*(_G.graph)) { }
  };
};

template<typename Graph>
class ResGraphWrapper : public GraphWrapper<Graph> {
public:
  ResGraphWrapper(Graph& _graph) : GraphWrapper<Graph>(_graph) { }
};

template <typename Graph> class MaxFlow {
  const Graph* g;
  typedef ResGraphWrapper<const Graph> ResGW;
public:
  MaxFlow(const Graph& _g) : g(&_g) { }
  void augmentOnShortestPath() {
    ResGW res_graph(*g);
    typename ResGW::template NodeMap<int> pred(res_graph); 
  }
};

int main(int, char **) {
  ListGraph G;
  MaxFlow<ListGraph> max_flow_test(G);
  max_flow_test.augmentOnShortestPath();
  return 0;
}
