/* -*- C++ -*-
 * src/test/sym_graph_test.cc - Part of HUGOlib, a generic C++ optimization library
 *
 * Copyright (C) 2004 Egervary Jeno Kombinatorikus Optimalizalasi Kutatocsoport
 * (Egervary Combinatorial Optimization Research Group, EGRES).
 *
 * Permission to use, modify and distribute this software is granted
 * provided that this copyright notice appears in all copies. For
 * precise terms see the accompanying LICENSE file.
 *
 * This software is provided "AS IS" with no warranty of any kind,
 * express or implied, and with no claim as to its suitability for any
 * purpose.
 *
 */

#include<iostream>

#include<hugo/skeletons/sym_graph.h>

#include<hugo/list_graph.h>
#include<hugo/smart_graph.h>
#include<hugo/full_graph.h>

#include"test_tools.h"
#include"graph_test.h"
#include"sym_graph_test.h"

/**
\file
This test makes consistency checks of list graph structures.

G.addNode(), G.addEdge(), G.tail(), G.head()

\todo Checks for empty graphs and isolated points.
conversion.
*/

using namespace hugo;

template<class Graph> void checkPetersen(Graph &G)
{
  typedef typename Graph::NodeIt NodeIt;


  checkGraphNodeList(G,10);
  checkGraphEdgeList(G,30);
  checkGraphSymEdgeList(G,15);

  for(NodeIt n(G);n!=INVALID;++n) {
    checkGraphInEdgeList(G,n,3);
    checkGraphOutEdgeList(G,n,3);
  }  
}

//Compile Graph
template void hugo::checkCompileStaticSymGraph<skeleton::StaticSymGraph>
(skeleton::StaticSymGraph &);

template void hugo::checkCompileSymGraph<skeleton::ExtendableSymGraph>
(skeleton::ExtendableSymGraph &);

template void hugo::checkCompileErasableSymGraph<skeleton::ErasableSymGraph>
(skeleton::ErasableSymGraph &);


//Compile SymSmartGraph
template void hugo::checkCompileSymGraph<SymSmartGraph>(SymSmartGraph &);
template void hugo::checkCompileGraphFindEdge<SymSmartGraph>(SymSmartGraph &);

//Compile SymListGraph
template void hugo::checkCompileSymGraph<SymListGraph>(SymListGraph &);
template void hugo::checkCompileErasableSymGraph<SymListGraph>(SymListGraph &);
template void hugo::checkCompileGraphFindEdge<SymListGraph>(SymListGraph &);

int main() 
{
  {
    SymSmartGraph G;
    addSymPetersen(G);
    checkPetersen(G);
  }
  {
    SymListGraph G;
    addSymPetersen(G);
    checkPetersen(G);
  }

  ///\file
  ///\todo map tests.
  ///\todo copy constr tests.

  std::cout << __FILE__ ": All tests passed.\n";

  return 0;
}
