// This example was started by Guillaume Laurent.
// It has become a place to dump code that tests parts of the
// gnomemm canvas code. Little thought has been given to the
// actual on-screen output.

#include <libgnomecanvasmm.h>
#include <libgnomecanvasmm/polygon.h>
#include <iostream>

class CanvasExample : public Gnome::Canvas::CanvasAA
{
	typedef Gnome::Canvas::CanvasAA Parent;

public:
	CanvasExample(double *, int);
	virtual ~CanvasExample();

private:

	///Event handler function that handles dragging nodes of triangle
	bool event_handler(GdkEvent* e, int b);

	///Event handler function that handles dragging triangle
	bool tri_mover(GdkEvent* e);

	///Coordinates of Weight Point of tirangle
	Gnome::Art::Point * wp;
	///Array of nodes of planefigure
	Gnome::Canvas::Ellipse ** nodes;
	///Sides of planefigure
	Gnome::Canvas::Polygon * sides;
	///Group of graphical elements of triangle
	Gnome::Canvas::Group triangle;

	///Indicates whether the button of mouse is pressed or not
	bool isbutton;

	///Number Of Elements - the number of nodes
	int noe;

	///Array of coordinates
	double * coordinates;

	///At this location was the mousebutton pressed.
	///It helps to calculate the distance of dragging.
	double clicked_x, clicked_y;

	///Remembers which Gnome::Canvas::Item was pressed.
	///this variable is needed, because
	///1. we cannot query the item at he cursor as fast as it could not cause a Segmentation Fault
	///2. we would like to handle only ony item per movement, therefore quering it is not a working solution
	Gnome::Canvas::Item * active_item;


};

///When we click on the weight point we can drag the whole triangle. This function resolves it.
bool CanvasExample::tri_mover(GdkEvent* e)
{
	switch(e->type)
	{
		case GDK_BUTTON_PRESS:
			clicked_x=e->button.x;
			clicked_y=e->button.y;
			isbutton=true;
			break;
		case GDK_BUTTON_RELEASE:
			isbutton=false;
			active_item=NULL;
			break;
		case GDK_MOTION_NOTIFY:
			if(isbutton)
			{
				double dx=e->motion.x-clicked_x;
				double dy=e->motion.y-clicked_y;

				Gnome::Canvas::Points coos;

				for(int i=0;i<=noe;i++)
				{
					nodes[i]->move(dx,dy);

					double x=(coordinates[2*i]+=dx);
					double y=(coordinates[2*i+1]+=dy);

					if(i!=noe)coos.push_back(Gnome::Art::Point(x,y));

				}

				clicked_x=e->motion.x;
				clicked_y=e->motion.y;

				sides->property_points().set_value(coos);
			}
		default: break;
	}
	return true;
}

///This function moves only one node of triangle,
///but recalculate the location of wight point,
///and also redraw the sides of the planefigure.
bool CanvasExample::event_handler(GdkEvent* e, int b)
{
	switch(e->type)
	{
		case GDK_BUTTON_PRESS:
			clicked_x=e->button.x;
			clicked_y=e->button.y;
			active_item=(get_item_at(e->button.x, e->button.y));
			isbutton=true;
			break;
		case GDK_BUTTON_RELEASE:
			isbutton=false;
			active_item=NULL;
			break;
		case GDK_MOTION_NOTIFY:
			if(isbutton)
			{
				//double x1, y1, x2, y2;
				//(get_item_at(e->motion.x, e->motion.y))->get_bounds(x1, y1, x2, y2);
				//printf("Item coos: %d %d %d %d\n", (int)x1, (int)y1, (int)x2, (int)y2);
				//printf("Mouse is moved! %d %d\n",(int)e->motion.x,(int)e->motion.y);
				double dx=e->motion.x-clicked_x;
				double dy=e->motion.y-clicked_y;
				active_item->move(dx, dy);

				coordinates[2*b]+=dx;
				coordinates[2*b+1]+=dy;

				Gnome::Canvas::Points coos;

				double x_wp=0;
				double y_wp=0;

				for(int i=0;i<noe;i++)
				{
					coos.push_back(Gnome::Art::Point(coordinates[2*i], coordinates[2*i+1]));

					x_wp+=coordinates[2*i];
					y_wp+=coordinates[2*i+1];
				}

				sides->property_points().set_value(coos);

				x_wp/=noe;
				y_wp/=noe;

				dx=x_wp-coordinates[noe*2];
				dy=y_wp-coordinates[noe*2+1];
				nodes[noe]->move(dx, dy);

				coordinates[noe*2]+=dx;
				coordinates[noe*2+1]+=dy;

				clicked_x=e->motion.x;
				clicked_y=e->motion.y;
			}
		default: break;
	}
	return true;
}

CanvasExample::CanvasExample(double * coosarray, int numofcoos):triangle(*(root()), 0, 0),isbutton(false),active_item(NULL)
{
	noe=numofcoos/2;

	coordinates=new double [numofcoos+2];

	double x_wp=0;
	double y_wp=0;

	Gnome::Canvas::Points coos;
	for(int i=0;i<numofcoos;i+=2)
	{
		coordinates[i]=coosarray[i];
		coordinates[i+1]=coosarray[i+1];
		coos.push_back(Gnome::Art::Point(coordinates[i],
						 coordinates[i+1]));

		x_wp+=coordinates[i];
		y_wp+=coordinates[i+1];

	}

	sides=new Gnome::Canvas::Polygon(triangle, coos);
	*sides << Gnome::Canvas::Properties::outline_color("green");
	sides->property_width_pixels().set_value(10);

	nodes=new Gnome::Canvas::Ellipse* [noe+1];

	for(int i=0; i<noe;i++)
	{
		nodes[i]= new Gnome::Canvas::Ellipse(triangle, coos[i].get_x()-20, coos[i].get_y()-20, coos[i].get_x()+20, coos[i].get_y()+20);
		*(nodes[i]) << Gnome::Canvas::Properties::fill_color("blue");
		*(nodes[i]) << Gnome::Canvas::Properties::outline_color("black");
		(nodes[i])->signal_event().connect(sigc::bind(sigc::mem_fun(*this, &CanvasExample::event_handler),i));
	}

	coordinates[numofcoos]=x_wp/noe;
	coordinates[numofcoos+1]=y_wp/noe;

	wp=new Gnome::Art::Point(coordinates[numofcoos],coordinates[numofcoos+1]);

	nodes[noe]= new Gnome::Canvas::Ellipse
	(
		triangle,
		coordinates[numofcoos]-20,
		coordinates[numofcoos+1]-20,
		coordinates[numofcoos]+20,
		coordinates[numofcoos+1]+20
	);
	*(nodes[noe]) << Gnome::Canvas::Properties::fill_color("blue");
	*(nodes[noe]) << Gnome::Canvas::Properties::outline_color("black");
	(nodes[noe])->signal_event().connect(sigc::mem_fun(*this, &CanvasExample::tri_mover));



}

CanvasExample::~CanvasExample()
{
}

//MainWin:

class MainWin : public Gtk::Window
{
public:
	MainWin(const std::string& title, double *, int);

protected:
	//Member widgets:
	CanvasExample m_canvas;
};

MainWin::MainWin(const std::string& title, double * coosarray, int noc):m_canvas(coosarray, noc)
{
	set_title (title);
	add(m_canvas);
	set_default_size(900,600);

	show_all();
}

//main():

int main(int argc, char *argv[])
{
	if((argc>=7)&& (argc%2) )
	{
		double * coosarray=new double[argc];

		for(int i=1;i<argc;i++)
		{
			coosarray[i-1]=atof(argv[i]);
			printf("%g%c",coosarray[i-1],i%2?' ':'\n');
		}

		Gnome::Canvas::init();
		Gtk::Main app(argc, argv);

		MainWin mainwin("Magic Triangle",coosarray,argc-1);
		app.run(mainwin);
	}

	return 0;
}
