// -*- c++ -*-
#include <iostream>
#include <fstream>
#include <vector>

#include <sage_graph.h>
//#include <smart_graph.h>
//#include <dimacs.h>
#include <hugo/time_measure.h>
#include <for_each_macros.h>
#include <bfs_dfs.h>
#include <bipartite_graph_wrapper.h>
#include <hugo/maps.h>
#include <hugo/max_flow.h>
#include <graph_gen.h>
#include <max_bipartite_matching.h>

using namespace hugo;

using std::cin;
using std::cout;
using std::endl;

int main() {
  //typedef UndirListGraph Graph; 
  typedef BipartiteGraph<SageGraph> Graph;
  
  typedef Graph::Node Node;
  typedef Graph::NodeIt NodeIt;
  typedef Graph::Edge Edge;
  typedef Graph::EdgeIt EdgeIt;
  typedef Graph::OutEdgeIt OutEdgeIt;

  Graph g;

  int a;
  cout << "number of nodes in the first color class=";
  cin >> a; 
  int b;
  cout << "number of nodes in the second color class=";
  cin >> b; 
  int m;
  cout << "number of edges=";
  cin >> m; 
  
  cout << "Generatig a random bipartite graph..." << endl;
  random_init();
  randomBipartiteGraph(g, a, b, m);

//   cout << "Edges of the bipartite graph:" << endl;
//   FOR_EACH_LOC(EdgeIt, e, g) cout << e << " ";
//   cout << endl;

//   cout << "Nodes:" << endl;
//   FOR_EACH_LOC(Graph::NodeIt, v, g) cout << v << " ";
//   cout << endl;
//   cout << "Nodes in T:" << endl;
//   FOR_EACH_INC_LOC(Graph::ClassNodeIt, v, g, Graph::T_CLASS) cout << v << " ";
//   cout << endl;
//   cout << "Nodes in S:" << endl;
//   FOR_EACH_INC_LOC(Graph::ClassNodeIt, v, g, Graph::S_CLASS) cout << v << " ";
//   cout << endl;

//   cout << "Erasing the first node..." << endl;
//   NodeIt n;
//   g.first(n);
//   g.erase(n);
//   cout << "Nodes of the bipartite graph:" << endl;
//   FOR_EACH_GLOB(n, g) cout << n << " ";
//   cout << endl;

//   cout << "Nodes in T:" << endl;
//   FOR_EACH_INC_LOC(Graph::ClassNodeIt, v, g, Graph::T_CLASS) cout << v << " ";
//   cout << endl;
//   cout << "Nodes in S:" << endl;
//   FOR_EACH_INC_LOC(Graph::ClassNodeIt, v, g, Graph::S_CLASS) cout << v << " ";
//   cout << endl;

  typedef stBipartiteGraphWrapper<Graph> stGW;
  stGW stgw(g);
  ConstMap<stGW::Edge, int> const1map(1);

  Timer ts;
  cout << "max bipartite matching with stGraphWrapper..." << endl;
  ts.reset();
  stGW::EdgeMap<int> flow(stgw);
  MaxFlow<stGW, int, ConstMap<stGW::Edge, int>, stGW::EdgeMap<int> > 
    max_flow_test(stgw, stgw.S_NODE, stgw.T_NODE, const1map, flow);
  max_flow_test.run();
//  while (max_flow_test.augmentOnShortestPath()) { }
//  typedef ListGraph MutableGraph;
//  while (max_flow_test.augmentOnBlockingFlow1<MutableGraph>()) {
//  while (max_flow_test.augmentOnBlockingFlow2()) {
//   cout << max_flow_test.flowValue() << endl;
//  }
  cout << "matching value: " << max_flow_test.flowValue() << endl;
  cout << "elapsed time: " << ts << endl;
//   FOR_EACH_LOC(stGW::EdgeIt, e, stgw) { 
//     if (flow[e]) cout << e << endl; 
//   }
  cout << endl;

  typedef ConstMap<Graph::Edge, int> EdgeCap; 
  EdgeCap ge1(1);
  typedef ConstMap<Graph::Node, int> NodeCap;
  NodeCap gn1(1);
  typedef Graph::EdgeMap<int> EdgeFlow;
  EdgeFlow gef(g); //0
  typedef Graph::NodeMap<int> NodeFlow; 
  NodeFlow gnf(g); //0 

  typedef stGW::EdgeMapWrapper<EdgeCap, NodeCap> CapMap; 
  typedef stGW::EdgeMapWrapper<EdgeFlow, NodeFlow> FlowMap; 
  CapMap cm(ge1, gn1);
  FlowMap fm(gef, gnf);

  //Timer ts;
  cout << "max bipartite matching with stGraphWrapper..." << endl;
  ts.reset();
  //stGW::EdgeMap<int> flow(stgw);
  MaxFlow<stGW, int, CapMap, FlowMap> 
    max_flow_test1(stgw, stgw.S_NODE, stgw.T_NODE, cm, fm);
  max_flow_test1.run();
//  while (max_flow_test.augmentOnShortestPath()) { }
//  typedef ListGraph MutableGraph;
//  while (max_flow_test.augmentOnBlockingFlow1<MutableGraph>()) {
//  while (max_flow_test.augmentOnBlockingFlow2()) {
//   cout << max_flow_test.flowValue() << endl;
//  }
  cout << "matching value: " << max_flow_test1.flowValue() << endl;
  cout << "elapsed time: " << ts << endl;
//   FOR_EACH_LOC(Graph::EdgeIt, e, g) { 
//     if (gef[e]) cout << e << endl; 
//   }
  cout << endl;

  cout << "max bipartite matching with stGraphWrapper..." << endl;
  ts.reset();
  FOR_EACH_LOC(Graph::EdgeIt, e, g) gef.set(e, 0); 
  FOR_EACH_LOC(Graph::NodeIt, n, g) gnf.set(n, 0); 
  MaxBipartiteMatching<Graph, ConstMap<Graph::Edge, int>, ConstMap<Graph::Node, int>, 
    Graph::EdgeMap<int>, Graph::NodeMap<int> > 
    matching_test(g, ge1, gn1, gef, gnf);
  matching_test.run();

  cout << "matching value: " << matching_test.matchingValue() << endl;
  cout << "elapsed time: " << ts << endl;
//   FOR_EACH_LOC(Graph::EdgeIt, e, g) { 
//     if (gef[e]) cout << e << endl; 
//   }
  cout << endl;

  cout << "max bipartite matching with MaxBipartiteMatching..." << endl;
  ts.reset();
  FOR_EACH_LOC(Graph::EdgeIt, e, g) gef.set(e, 0); 
  //FOR_EACH_LOC(Graph::NodeIt, n, g) gnf.set(n, 0); 
  typedef MaxBipartiteMatching<Graph, ConstMap<Graph::Edge, int>, 
    ConstMap<Graph::Node, int>, 
    Graph::EdgeMap<int>, Graph::NodeMap<int> > MaxBipartiteMatching;
  MaxBipartiteMatching matching_test_1(g, ge1, gn1, gef/*, gnf*/);
  matching_test_1.run();

  cout << "matching value: " << matching_test_1.matchingValue() << endl;
  cout << "elapsed time: " << ts << endl;
//   FOR_EACH_LOC(Graph::EdgeIt, e, g) { 
//     if (gef[e]) cout << e << endl; 
//   }
  cout << endl;

  cout << "testing optimality with MaxBipartiteMatching..." << endl;
  ts.reset();
  matching_test_1.run(MaxBipartiteMatching::GEN_MATCHING);
  cout << "matching value: " << matching_test_1.matchingValue() << endl;
  cout << "elapsed time: " << ts << endl;

  cout << "testing optimality with MaxBipartiteMatching..." << endl;
  ts.reset();
  matching_test_1.run(MaxBipartiteMatching::GEN_MATCHING_WITH_GOOD_NODE_FLOW);
  cout << "matching value: " << matching_test_1.matchingValue() << endl;
  cout << "elapsed time: " << ts << endl;

  return 0;
}
