/*
reverse_bfs
by jacint
Performs a bfs on the out edges. It does not count predecessors, 
only the distances, but one can easily modify it to know the pred as well.

Constructor: 

reverse_bfs(graph_type& G, node_iterator t)



Member functions:

void run(): runs a reverse bfs from t

  The following function should be used after run() was already run.

int dist(node_iterator v) : returns the distance from v to t. It is the number of nodes if t is not reachable from v.

*/
#ifndef REVERSE_BFS_HH
#define REVERSE_BFS_HH

#include <queue>

//#include <marci_list_graph.hh>
//#include <marci_property_vector.hh>



namespace  marci {

  template <typename graph_type>
  class reverse_bfs {

    typedef typename graph_type::NodeIt NodeIt;
    typedef typename graph_type::EdgeIt EdgeIt;
    typedef typename graph_type::EachNodeIt EachNodeIt;
    typedef typename graph_type::EachEdgeIt EachEdgeIt;
    typedef typename graph_type::OutEdgeIt OutEdgeIt;
    typedef typename graph_type::InEdgeIt InEdgeIt;
    typedef typename graph_type::SymEdgeIt SymEdgeIt;



    graph_type& G;
    NodeIt t;
//    node_property_vector<graph_type, edge_iterator> pred;
    //node_property_vector<graph_type, int>
    typename graph_type::NodeMap<int> distance;
    

  public :

    /*
      The distance of the nodes is n, except t for which it is 0.
    */
    reverse_bfs(graph_type& _G, NodeIt _t) : 
      G(_G), t(_t), 
      distance(G, G.nodeNum()) {
      distance.set(t,0);
    }
    
    void run() {

      //node_property_vector<graph_type, bool> 
      typename graph_type::NodeMap<bool> reached(G, false); 
      reached.set(t, true);

      std::queue<NodeIt> bfs_queue;
      bfs_queue.push(t);

      while (!bfs_queue.empty()) {

        NodeIt v=bfs_queue.front();	
	bfs_queue.pop();

	for(InEdgeIt e=G.template first<InEdgeIt>(v); e.valid(); ++e) {
	  NodeIt w=G.tail(e);
	  if (!reached.get(w)) {
	    bfs_queue.push(w);
	    distance.set(w, distance.get(v)+1);
	    reached.set(w, true);
	  }
	}
      }
    }



    int dist(NodeIt v) {
      return distance.get(v);
    }


  };

} // namespace hugo

#endif //REVERSE_BFS_HH


