#include <iostream>
#include <fstream>

#include <list_graph.hh>
#include <dimacs.hh>
#include <preflow_hl2.h>
#include <time_measure.h>

using namespace hugo;

// Use a DIMACS max flow file as stdin.
// read_dimacs_demo < dimacs_max_flow_file
int main(int, char **) {
  typedef ListGraph::NodeIt NodeIt;
  typedef ListGraph::EachEdgeIt EachEdgeIt;

  ListGraph G;
  NodeIt s, t;
  ListGraph::EdgeMap<int> cap(G);
  readDimacsMaxFlow(std::cin, G, s, t, cap);

  std::cout << "preflow_hl2 demo ..." << std::endl;
  
  double mintime=1000000;

  for ( int i=1; i!=11; ++i ) {
    double pre_time=currTime();
    preflow_hl2<ListGraph, int> max_flow_test(G, s, t, cap);
    double post_time=currTime();
    if ( mintime > post_time-pre_time ) mintime = post_time-pre_time;
  }

  preflow_hl2<ListGraph, int> max_flow_test(G, s, t, cap);
    
  ListGraph::NodeMap<bool> cut(G);
  max_flow_test.minCut(cut); 
  int min_cut_value=0;
  for(EachEdgeIt e=G.first<EachEdgeIt>(); e.valid(); ++e) {
    if (cut.get(G.tail(e)) && !cut.get(G.head(e))) min_cut_value+=cap.get(e);
  }

  ListGraph::NodeMap<bool> cut1(G);
  max_flow_test.minMinCut(cut1); 
  int min_min_cut_value=0;
  for(EachEdgeIt e=G.first<EachEdgeIt>(); e.valid(); ++e) {
    if (cut.get(G.tail(e)) && !cut.get(G.head(e))) 
      min_min_cut_value+=cap.get(e);
  }

  ListGraph::NodeMap<bool> cut2(G);
  max_flow_test.maxMinCut(cut2); 
  int max_min_cut_value=0;
  for(EachEdgeIt e=G.first<EachEdgeIt>(); e.valid(); ++e) {
    if (cut2.get(G.tail(e)) && !cut2.get(G.head(e))) 
      max_min_cut_value+=cap.get(e);
  }
  
  std::cout << "min time of 10 runs: " << mintime << " sec"<< std::endl; 
  std::cout << "flow value: "<< max_flow_test.maxFlow() << std::endl;
  std::cout << "min cut value: "<< min_cut_value << std::endl;
  std::cout << "min min cut value: "<< min_min_cut_value << std::endl;
  std::cout << "max min cut value: "<< max_min_cut_value << std::endl;

  return 0;
}
