#include <iostream>
#include <fstream>

#include <list_graph.hh>
#include <dimacs.hh>
#include <preflow_max_flow.h>
#include <time_measure.h>

using namespace hugo;

// Use a DIMACS max flow file as stdin.
// read_dimacs_demo < dimacs_max_flow_file
int main(int, char **) {
  typedef ListGraph::NodeIt NodeIt;
  typedef ListGraph::EachEdgeIt EachEdgeIt;
typedef ListGraph::EachNodeIt EachNodeIt;

  ListGraph G;
  NodeIt s, t;
  ListGraph::EdgeMap<int> cap(G);
  readDimacsMaxFlow(std::cin, G, s, t, cap);

  std::cout << "preflow_max_flow demo ..." << std::endl;
  
  double pre_time=currTime();
  preflow_max_flow<ListGraph, int> max_flow_test(G, s, t, cap);
  ListGraph::NodeMap<bool> cut=max_flow_test.minCut();
  double post_time=currTime();
  
  int cut_value=0;
  for(EachEdgeIt e=G.first<EachEdgeIt>(); e.valid(); ++e) {
    if (cut.get(G.tail(e)) && !cut.get(G.head(e))) cut_value+=cap.get(e);
  }
  
  std::cout << "elapsed time: " << post_time-pre_time << " sec"<< std::endl; 
  std::cout << "flow value: "<< max_flow_test.maxFlow() << std::endl;
  std::cout << "cut value: "<< cut_value << std::endl;

  return 0;
}
