#include <iostream>
#include <fstream>

#include <list_graph.hh>
#include <dimacs.hh>
#include <preflow_param.h>
#include <time_measure.h>

using namespace hugo;

// Use a DIMACS max flow file as stdin.
// read_dimacs_demo < dimacs_max_flow_file
int main(int, char **) {
  typedef ListGraph::NodeIt NodeIt;
  typedef ListGraph::EachEdgeIt EachEdgeIt;

  ListGraph G;
  NodeIt s, t;
  ListGraph::EdgeMap<int> cap(G);
  readDimacsMaxFlow(std::cin, G, s, t, cap);

  std::cout << "preflow parameters test ..." << std::endl;

  double min=1000000;  

  int _j=0;
  int _k=0;

  for (int j=1; j!=40; ++j ){
    for (int k=1; k!=j; ++k ){
      
      double mintime=1000000;

      for ( int i=1; i!=4; ++i ) {
	double pre_time=currTime();
	preflow_param<ListGraph, int> max_flow_test(G, s, t, cap, j, k);
	double post_time=currTime();
	if ( mintime > post_time-pre_time ) mintime = post_time-pre_time;
      }
      if (min > mintime ) {min=mintime; _j=j; _k=k;}
    }
  }

  std::cout<<"Min. at ("<<_j<<","<<_k<<") in time "<<min<<std::endl;
  
  return 0;
}
