#include "io_helper.h"

namespace lemon {
  void xml(XmlIo &x, MapValue::Type& v)
  {
    if(x.write()) {
      switch (v)
      {
        case MapValue::NUMERIC:
          { x("type", std::string("numeric")); }
          break;
        case MapValue::STRING:
          { x("type", std::string("string")); }
          break;
      }
    }
    else {
      std::string type;
      { x("type", type); }
      if (type == "numeric")
      {
        v = MapValue::NUMERIC;
      }
      else if (type == "string")
      {
        v = MapValue::STRING;
      }
      else
      {
        throw FormatError("Bad format");
      }
    }
  }
};
