#ifndef LEMON_MIP_CBC_H
#define LEMON_MIP_CBC_H

///\file
///\brief Header of the LEMON-CBC mip solver interface.
///\ingroup lp_group

#include "CbcModel.hpp"

#include <lemon/lp_cbc.h>

namespace lemon {
  /// \brief Interface for the CBC MIP solver
  /// 
  /// This class implements an interface for the CBC MIP solver.
  ///\ingroup lp_group
  class MipCbc : public MipSolverBase, public LpCbc{
  protected:

	CbcModel* model;
  public:
  
    typedef MipSolverBase ParentMip;
    typedef LpCbc ParentLp;
    
    MipCbc();
    ~MipCbc();
    
    
    
  protected:
  
    virtual ColTypes _colType(int col) const;
    virtual void _colType(int col, ColTypes col_type);
    
    virtual LpCbc::SolveExitStatus _solve();
    virtual LpCbc::SolutionStatus _getMipStatus() const;
    virtual ParentLp::Value _getPrimal(int i) const;
    virtual ParentLp::Value _getPrimalValue() const;
  };

} //END OF NAMESPACE LEMON

#endif // END OF LEMON_MIP_CBC_H
