#include <iostream>
#include <lemon/lp.h>

using namespace std;
using namespace lemon;

int main() {
  Lp lp;
  
  Lp::Col x1 = lp.addCol();
  Lp::Col x2 = lp.addCol();
  
  lp.addRow(x1 <= 10);
  lp.addRow(x2 <= 20);

  lp.obj(x1 + x2);
  lp.max();

  lp.solve();

  cout << "Primal status:          " << lp.primalType() << endl;
  cout << "Primal objective value: " << lp.primal() << endl << endl;
  
  cout << "Primal value of the columns:" << endl;
  cout << "x1 = " << lp.primal(x1) << endl;
  cout << "x2 = " << lp.primal(x2) << endl;

  return 0;
}
