#define REMOVE_BEFORE_RELEASE

#include "test_log.h"
#include "components.h"
#include <lemon/planar_graph.h>
#include <iostream>

using namespace lemon;
using namespace std;

void planar_graph_comp_test() {
    cout << "Planar graph test" << endl;
    PlanarGraph g;
    PlanarGraph::Node n0 = g.addNode();
    PlanarGraph::Node n1 = g.addNode();
    PlanarGraph::Node n2 = g.addNode();
    PlanarGraph::Node n3 = g.addNode();
    PlanarGraph::Node n4 = g.addNode();
    PlanarGraph::Node n5 = g.addNode();
    PlanarGraph::Edge a0 = g.addEdge(n0,n1,INVALID,INVALID);
    PlanarGraph::Edge a1 = g.addEdge(n1,n2,a0,INVALID);
    PlanarGraph::Edge a2 = g.addEdge(n2,n0,a1,a0);
    PlanarGraph::Edge a3 = g.addEdge(n3,n4,INVALID,INVALID);
    PlanarGraph::Edge a4 = g.addEdge(n4,n5,a3,INVALID);
    PlanarGraph::Edge a5 = g.addEdge(n5,n3,a4,a3);
    cout << "Before joining:" << endl;
    printNodesWithArcs(g);
    printFacesWithArcs(g);

    PlanarGraph::Edge a6 = g.addEdge(n2,n3,a1,a5);

    cout << "After joining:" << endl;
    printNodesWithArcs(g);
    printFacesWithArcs(g);

    g.erase(a6);

    cout << "After splitting:" << endl;
    printNodesWithArcs(g);
    printFacesWithArcs(g);
    g.print();
    cout << endl;
}
