#include "test_log.h"
#include <iostream>

using namespace std;
using namespace lemon;

void printNodesWithArcs(const lemon::PlanarGraph &g) {
    cout << "Node: arcs (CCW)" << endl;
    for (PlanarGraph::NodeIt it(g); it != INVALID; ++it) {
        cout << g.id(it) << ": ";
        ccwTest(g,it);
    }
}

void printFacesWithArcs(const lemon::PlanarGraph &g) {
    cout << "Face: arcs (CW)" << endl;
    for (PlanarGraph::FaceIt it(g); it != INVALID; ++it) {
        cout << g.id(it) << ": ";
        for (PlanarGraph::CwBoundaryArcIt it2(g,it); it2 != INVALID; ++it2) {
            cout << g.id(it2) << " ";
        }
        cout << endl;
    }
    cout << endl;
}

void ccwTest(const PlanarGraph &g, PlanarGraph::Node n) {
    //for undirected planar graph, IncEdgeIt provides the CCW behavior by
    //default.
    for (PlanarGraph::IncEdgeIt it(g,n); it != INVALID; ++it) {
        cout << g.id(it) << " ";
    }
    cout << endl;
}

