#include <iostream>
#include <lemon/smart_graph.h>
#include <lemon/lgf_reader.h>
#include <lemon/preflow.h>

using namespace lemon;

int main() {
    SmartDigraph g;

    SmartDigraph::ArcMap<int> cap(g);
    SmartDigraph::NodeMap<int> lab(g);
    SmartDigraph::Node s, t;

    try {
        digraphReader(g, "preflow_bug.lgf").
            arcMap("capacity", cap).
            nodeMap("label", lab).
            run();
    } catch (Exception& error) {
        std::cerr << "Error: " << error.what() << std::endl;
        return -1;
    }

    for (SmartDigraph::NodeIt nIt1(g); nIt1 != INVALID; ++nIt1)
    {

        std::cout <<
        "Processing node: " << g.id(nIt1) << " label: " << lab[nIt1] << std::endl;

        for (SmartDigraph::NodeIt nIt2(g); nIt2 != INVALID; ++nIt2)
        {
                std::cout <<
                " processing node: " << g.id(nIt1) << " label: " << lab[nIt1] << " inner node:" << g.id(nIt2) << " label: " << lab[nIt2] << std::endl;

                Preflow<SmartDigraph, SmartDigraph::ArcMap<int> > pf(g, cap, nIt1, nIt2);
//                Preflow<SmartDigraph, SmartDigraph::ArcMap<int> >
//                  ::SetStandardElevator<LinkedElevator<SmartDigraph, SmartDigraph::Node> >
//                  ::Create pf(g, cap, nIt1, nIt2);

                pf.run();
        }

    }

    return 0;
}
