#include <lemon/list_graph.h> // ListDigraph

#include <iostream> // cout, endl

int main( int argc, char* argv[] )
{
  lemon::ListDigraph digraph;
  digraph.addNode();
  digraph.addNode();

  const int initial_map_value = -1;
  lemon::ListDigraph::NodeMap< int > node_to_value_map( digraph,
                                                        initial_map_value );

  digraph.addNode();
  digraph.addNode();

  for( lemon::ListDigraph::NodeIt iter( digraph );
       iter != lemon::INVALID; ++iter )
  {
    const int expected_map_value = initial_map_value;
    const bool b_matched = node_to_value_map[ iter ] == expected_map_value;
    std::cout << "For Digraph Node ID: " << digraph.id( iter ) << ", "
              << "the expected map value is: " << expected_map_value << ", "
              << ( b_matched ? "and " : "but " )
              << "the observed map value is: " << node_to_value_map[ iter ]
              << "." << std::endl;
  }

  return 0;
}
