#include <vector>
#include <iostream>
#include <list_graph.hh>
#include <bfs_iterator.hh>
#include <loader.h>

using namespace hugo;

int main(int, char **) {
  typedef ListGraph::NodeIt NodeIt;
  typedef ListGraph::EdgeIt EdgeIt;
  typedef ListGraph::EachNodeIt EachNodeIt;
  typedef ListGraph::EachEdgeIt EachEdgeIt;
  typedef ListGraph::OutEdgeIt OutEdgeIt;
  typedef ListGraph::InEdgeIt InEdgeIt;
  typedef ListGraph::SymEdgeIt SymEdgeIt;

  ListGraph G;
  LoadGraph(G, "demo.in");

  std::cout << "bfs from the first node" << std::endl;
  bfs<ListGraph> bfs_test(G, G.first<EachNodeIt>());
  bfs_test.run();
  std::cout << "reached: ";
  for(EachNodeIt i=G.first<EachNodeIt>(); i.valid(); ++i) {
    std::cout << bfs_test.reached.get(i) << " ";
  }
  std::cout<<std::endl;
  std::cout << "dist: ";
  for(EachNodeIt i=G.first<EachNodeIt>(); i.valid(); ++i) {
    std::cout << bfs_test.dist.get(i) << " ";
  }
  std::cout<<std::endl;
}
