#include <iostream>
#include <vector>
#include <string>

#include <list_graph.hh>
#include <bfs_iterator.hh>
#include <edmonds_karp.hh>

using namespace hugo;

int main (int, char*[])
{
  typedef ListGraph::NodeIt NodeIt;
  typedef ListGraph::EdgeIt EdgeIt;
  typedef ListGraph::EachNodeIt EachNodeIt;
  typedef ListGraph::EachEdgeIt EachEdgeIt;
  typedef ListGraph::OutEdgeIt OutEdgeIt;
  typedef ListGraph::InEdgeIt InEdgeIt;
  typedef ListGraph::SymEdgeIt SymEdgeIt;
  ListGraph G;
  std::vector<NodeIt> vector_of_NodeIts;
  for(int i=0; i!=8; ++i) vector_of_NodeIts.push_back(G.addNode());
  for(int i=0; i!=8; ++i)
    for(int j=0; j!=8; ++j) 
      if ((i<j)&&(i+j)%3) G.addEdge(vector_of_NodeIts[i], vector_of_NodeIts[j]);

  std::cout << "We construct a directed graph on the node set {0,1,2,...,7}," <<std::endl << "i-->j is arc iff i<j and (i+j)%3." << std::endl;
  std::cout << "number of nodes: " << count(G.first<EachNodeIt>()) << std::endl;

  for(EachNodeIt i=G.first<EachNodeIt>(); i.valid(); ++i) {
    std::cout << "node " << G.id(i) << std::endl;
    std::cout << " outdegree (OutEdgeIt): " << count(G.first<OutEdgeIt>(i)) << " "; 
    for(OutEdgeIt j=G.first<OutEdgeIt>(i); j.valid(); ++j) { 
      std::cout << "(" << G.id(G.tail(j)) << "--" << G.id(j) << "->" << G.id(G.head(j)) << ") ";
    }
    std::cout << std::endl; 

    std::cout<< " ";
    for(OutEdgeIt j=G.first<OutEdgeIt>(i); j.valid(); ++j) { 
      std::cout << G.aNode(j) << "->" << G.bNode(j) << " "; } 
    std::cout<<std::endl;

    std::cout << " indegree: (InEdgeIt) " << count(G.first<InEdgeIt>(i)) << " ";
    for(InEdgeIt j=G.first<InEdgeIt>(i); j.valid(); ++j) { 
      std::cout << j << " "; } 
    std::cout << std::endl;

    std::cout<< " ";
    for(InEdgeIt j=G.first<InEdgeIt>(i); j.valid(); ++j) { 
      std::cout << G.aNode(j) << "->" << G.bNode(j) << " "; } 
    std::cout<<std::endl;

    std::cout << " degree: (SymEdgeIt) " << count(G.first<SymEdgeIt>(i)) << " ";
    for(SymEdgeIt j=G.first<SymEdgeIt>(i); j.valid(); ++j) { 
      std::cout << j << " "; } 
    std::cout<<std::endl;

    std::cout<< " ";
    for(SymEdgeIt j=G.first<SymEdgeIt>(i); j.valid(); ++j) { 
      std::cout << G.aNode(j) << "->" << G.bNode(j) << " "; } 
    std::cout<<std::endl;
  }

  std::cout << "all edges: ";
  for(EachEdgeIt i=G.first<EachEdgeIt>(); i.valid(); ++i) {
    std::cout << i << " ";
  }
  std::cout << std::endl;

  std::cout << "node property array test" << std::endl;
  ListGraph::NodeMap<int> my_property_vector(G);
  EachNodeIt v;
  G.getFirst(v);
  my_property_vector.set(v, 42);
  my_property_vector.set(++G.first<EachNodeIt>(), 314);
  my_property_vector.set(++++G.first<EachNodeIt>(), 1956);
  my_property_vector.set(vector_of_NodeIts[3], 1989);
  my_property_vector.set(vector_of_NodeIts[4], 2003);
  my_property_vector.set(vector_of_NodeIts[7], 1978);
  std::cout << "some node property values..." << std::endl;
  for(EachNodeIt i=G.first<EachNodeIt>(); i.valid(); ++i) {
    std::cout << my_property_vector.get(i) << std::endl;
  }
  int _i=1;
  int _ii=1;
  ListGraph::EdgeMap<int> my_edge_property(G);
  for(EachEdgeIt i=G.first<EachEdgeIt>(); i.valid(); ++i) {
    my_edge_property.set(i, _i);
    _i*=_ii; ++_ii;
  }

  std::cout << "node and edge property values on the tails and heads of edges..." << std::endl;
  for(EachEdgeIt j=G.first<EachEdgeIt>(); j.valid(); ++j) {
    std::cout << my_property_vector.get(G.tail(j)) << "--" << my_edge_property.get(j) << "-->" << my_property_vector.get(G.head(j)) << " ";
  }
  std::cout << std::endl;
/*
  std::cout << "bfs from the first node" << std::endl;
  bfs<ListGraph> bfs_test(G, G.first<EachNodeIt>());
  bfs_test.run();
  std::cout << "reached: ";
  for(EachNodeIt i=G.first<EachNodeIt>(); i.valid(); ++i) {
    std::cout << bfs_test.reached.get(i) << " ";
  }
  std::cout<<std::endl;
  std::cout << "dist: ";
  for(EachNodeIt i=G.first<EachNodeIt>(); i.valid(); ++i) {
    std::cout << bfs_test.dist.get(i) << " ";
  }
  std::cout<<std::endl;
*/

  std::cout << "augmenting path flow algorithm test..." << std::endl;
  ListGraph flowG;

  NodeIt s=flowG.addNode();
  NodeIt v1=flowG.addNode();
  NodeIt v2=flowG.addNode();
  NodeIt v3=flowG.addNode();
  NodeIt v4=flowG.addNode();
  NodeIt t=flowG.addNode();
  
  ListGraph::NodeMap<std::string> node_name(flowG);
  node_name.set(s, "s");
  node_name.set(v1, "v1");
  node_name.set(v2, "v2");
  node_name.set(v3, "v3");
  node_name.set(v4, "v4");
  node_name.set(t, "t");

  EdgeIt s_v1=flowG.addEdge(s, v1);
  EdgeIt s_v2=flowG.addEdge(s, v2);
  EdgeIt v1_v2=flowG.addEdge(v1, v2);
  EdgeIt v2_v1=flowG.addEdge(v2, v1);
  EdgeIt v1_v3=flowG.addEdge(v1, v3);
  EdgeIt v3_v2=flowG.addEdge(v3, v2);
  EdgeIt v2_v4=flowG.addEdge(v2, v4);
  EdgeIt v4_v3=flowG.addEdge(v4, v3);
  EdgeIt v3_t=flowG.addEdge(v3, t);
  EdgeIt v4_t=flowG.addEdge(v4, t);

  ListGraph::EdgeMap<int> cap(flowG);

  cap.set(s_v1, 16);
  cap.set(s_v2, 13);
  cap.set(v1_v2, 10);
  cap.set(v2_v1, 4);
  cap.set(v1_v3, 12);
  cap.set(v3_v2, 9);
  cap.set(v2_v4, 14);
  cap.set(v4_v3, 7);
  cap.set(v3_t, 20);
  cap.set(v4_t, 4);

  std::cout << "on directed graph graph" << std::endl; //<< flowG;
  std::cout << "names and capacity values" << std::endl; 
  for(EachNodeIt i=flowG.first<EachNodeIt>(); i.valid(); ++i) { 
    std::cout << node_name.get(i) << ": ";
    std::cout << "out edges: ";
    for(OutEdgeIt j=flowG.first<OutEdgeIt>(i); j.valid(); ++j) 
      std::cout << node_name.get(flowG.tail(j)) << "-"<< cap.get(j) << "->" << node_name.get(flowG.head(j)) << " ";
    std::cout << "in edges: ";
    for(InEdgeIt j=flowG.first<InEdgeIt>(i); j.valid(); ++j) 
      std::cout << node_name.get(flowG.tail(j)) << "-"<< cap.get(j) << "->" << node_name.get(flowG.head(j)) << " ";
    std::cout << std::endl;
  }

  //flowG.deleteEdge(s_v1);
  //flowG.deleteEdge(s_v2);
  //flowG.deleteEdge(v1_v2);
  //flowG.deleteEdge(v1_v3);
  

  //flowG.setTail(v3_t, v2);
  //flowG.setHead(v3_t, s);
/*
  for(EachNodeIt i=flowG.first<EachNodeIt>(); i.valid(); ++i) { 
    std::cout << node_name.get(i) << ": ";
    std::cout << "out edges: ";
    for(OutEdgeIt j=flowG.first<OutEdgeIt>(i); j.valid(); ++j) 
      std::cout << node_name.get(flowG.tail(j)) << "-"<< cap.get(j) << "->" << node_name.get(flowG.head(j)) << " ";
    std::cout << "in edges: ";
    for(InEdgeIt j=flowG.first<InEdgeIt>(i); j.valid(); ++j) 
      std::cout << node_name.get(flowG.tail(j)) << "-"<< cap.get(j) << "->" << node_name.get(flowG.head(j)) << " ";
    std::cout << std::endl;
  }
  
  for(EachEdgeIt e=flowG.first<EachEdgeIt>(); e.valid(); ++e) {
    std::cout << node_name.get(flowG.tail(e)) << "-"<< cap.get(e) << "->" << node_name.get(flowG.head(e)) << " ";
  }
*/
  /*
  while (flowG.first<EachEdgeIt>().valid()) {
    flowG.deleteEdge(flowG.first<EachEdgeIt>());
    for(EachNodeIt i=flowG.first<EachNodeIt>(); i.valid(); ++i) { 
      std::cout << node_name.get(i) << ": ";
      std::cout << "out edges: ";
      for(OutEdgeIt j=flowG.first<OutEdgeIt>(i); j.valid(); ++j) 
	std::cout << node_name.get(flowG.tail(j)) << "-"<< cap.get(j) << "->" << node_name.get(flowG.head(j)) << " ";
      std::cout << "in edges: ";
      for(InEdgeIt j=flowG.first<InEdgeIt>(i); j.valid(); ++j) 
	std::cout << node_name.get(flowG.tail(j)) << "-"<< cap.get(j) << "->" << node_name.get(flowG.head(j)) << " ";
      std::cout << std::endl;
    }
  }
  
  while (flowG.first<EachNodeIt>().valid()) {
    flowG.deleteNode(flowG.first<EachNodeIt>());
    for(EachNodeIt i=flowG.first<EachNodeIt>(); i.valid(); ++i) { 
      std::cout << node_name.get(i) << ": ";
      std::cout << "out edges: ";
      for(OutEdgeIt j=flowG.first<OutEdgeIt>(i); j.valid(); ++j) 
	std::cout << node_name.get(flowG.tail(j)) << "-"<< cap.get(j) << "->" << node_name.get(flowG.head(j)) << " ";
      std::cout << "in edges: ";
      for(InEdgeIt j=flowG.first<InEdgeIt>(i); j.valid(); ++j) 
	std::cout << node_name.get(flowG.tail(j)) << "-"<< cap.get(j) << "->" << node_name.get(flowG.head(j)) << " ";
      std::cout << std::endl;
    }
  }
  */

  //std::cout << std::endl;


  {
    ListGraph::EdgeMap<int> flow(flowG, 0);
    MaxFlow<ListGraph, int, ListGraph::EdgeMap<int>, ListGraph::EdgeMap<int> > max_flow_test(flowG, s, t, flow, cap);
    /*
    max_flow_test.augmentOnBlockingFlow<ListGraph>();
    for(EachEdgeIt e=flowG.template first<EachEdgeIt>(); e.valid(); ++e) { 
      std::cout<<"("<<flowG.tail(e)<< "-"<<flow.get(e)<<"->"<<flowG.head(e)<<") ";
    }
    std::cout<<std::endl;
    max_flow_test.augmentOnBlockingFlow<ListGraph>();
    for(EachEdgeIt e=flowG.template first<EachEdgeIt>(); e.valid(); ++e) { 
      std::cout<<"("<<flowG.tail(e)<< "-"<<flow.get(e)<<"->"<<flowG.head(e)<<") ";
    }
    std::cout<<std::endl;*/
    max_flow_test.run();
    
    std::cout << "maximum flow: "<< std::endl;
    for(EachEdgeIt e=flowG.template first<EachEdgeIt>(); e.valid(); ++e) { 
      std::cout<<"("<<flowG.tail(e)<< "-"<<flow.get(e)<<"->"<<flowG.head(e)<<") ";
    }
    std::cout<<std::endl;
    std::cout << "flow value: "<< max_flow_test.flowValue() << std::endl;
  }

  {
    std::list<NodeIt> S;
    S.push_back(s); S.push_back(v3);
    std::list<NodeIt> T;
    T.push_back(t);

    ListGraph::EdgeMap<int> flow(flowG, 0);
    MaxFlow2<ListGraph, int, ListGraph::EdgeMap<int>, ListGraph::EdgeMap<int> > max_flow_test(flowG, S, T, flow, cap);
    max_flow_test.run();
    
    std::cout << "maximum flow: "<< std::endl;
    for(EachEdgeIt e=flowG.template first<EachEdgeIt>(); e.valid(); ++e) { 
      std::cout<<"("<<flowG.tail(e)<< "-"<<flow.get(e)<<"->"<<flowG.head(e)<<") ";
    }
    std::cout<<std::endl;
    std::cout << "flow value: "<< max_flow_test.flowValue() << std::endl;
  }

  return 0;
}
