// -*- c++ -*-

#include <iostream>
#include <vector>

#include <lemon/concept/graph.h>
#include <lemon/list_graph.h>
#include <lemon/smart_graph.h>
#include <lemon/full_graph.h>

#include "test_tools.h"
#include "graph_test.h"
#include "map_test.h"


using namespace lemon;
using namespace lemon::concept;


int main() {
  ///\file
  { // checking graph components
    function_requires<BaseGraphComponentConcept<BaseGraphComponent> >();

    function_requires<BaseIterableGraphComponentConcept<BaseIterableGraphComponent> >();

    function_requires<IDableGraphComponentConcept<IDableGraphComponent> >();
    function_requires<MaxIDableGraphComponentConcept<MaxIDableGraphComponent> >();

    function_requires<BaseExtendableGraphComponentConcept<BaseExtendableGraphComponent> >();
    function_requires<BaseErasableGraphComponentConcept<BaseErasableGraphComponent> >();
    function_requires<BaseClearableGraphComponentConcept<BaseClearableGraphComponent> >();

    function_requires<IterableGraphComponentConcept<IterableGraphComponent> >();

    function_requires<MappableGraphComponentConcept<MappableGraphComponent> >();

    function_requires<ExtendableGraphComponentConcept<ExtendableGraphComponent> >();
    function_requires<ErasableGraphComponentConcept<ErasableGraphComponent> >();
    function_requires<ClearableGraphComponentConcept<ClearableGraphComponent> >();
  }
  { // checking skeleton graphs
    function_requires<StaticGraphConcept<StaticGraph> >();
    function_requires<ExtendableGraphConcept<ExtendableGraph> >();
    function_requires<ErasableGraphConcept<ErasableGraph> >();
  }
  { // checking list graph
    function_requires<ErasableGraphConcept<ListGraph> >();

    checkGraph<ListGraph>();
    checkGraphNodeMap<ListGraph>();
    checkGraphEdgeMap<ListGraph>();
  }
  { // checking smart graph
    function_requires<ExtendableGraphConcept<SmartGraph> >();

    checkGraph<SmartGraph>();
    checkGraphNodeMap<SmartGraph>();
    checkGraphEdgeMap<SmartGraph>();
  }
  { // checking full graph
    function_requires<StaticGraphConcept<FullGraph> >();
  }

  std::cout << __FILE__ ": All tests passed.\n";

  return 0;
}
