// -*- c++ -*-
#ifndef LEMON_MIN_COST_GEN_FLOW_H
#define LEMON_MIN_COST_GEN_FLOW_H
//#include <iostream>
//#include <fstream>

//#include <lemon/smart_graph.h>
//#include <lemon/list_graph.h>
//#include <lemon/dimacs.h>
//#include <lemon/time_measure.h>
//#include <graph_wrapper.h>
//#include <lemon/preflow.h>
//#include <augmenting_flow.h>
//#include <preflow_res.h>
#include <lemon/../work/marci/lp/lp_solver_wrapper.h>

namespace lemon {

  template<typename Edge, typename EdgeIndexMap> 
  class PrimalMap {
  protected:
    LPSolverWrapper* lp;
    EdgeIndexMap* edge_index_map;
  public:
    PrimalMap(LPSolverWrapper& _lp, EdgeIndexMap& _edge_index_map) : 
      lp(&_lp), edge_index_map(&_edge_index_map) { }
    double operator[](Edge e) const { 
      return lp->getPrimal((*edge_index_map)[e]);
    }
  };

  // excess: rho-delta
  template <typename Graph, typename Num,
	    typename Excess=typename Graph::template NodeMap<Num>, 
	    typename LCapMap=typename Graph::template EdgeMap<Num>,
	    typename CapMap=typename Graph::template EdgeMap<Num>,
            typename FlowMap=typename Graph::template EdgeMap<Num>,
	    typename CostMap=typename Graph::template EdgeMap<Num> >
  class MinCostGenFlow {
  protected:
    const Graph& g;
    const Excess& excess;
    const LCapMap& lcapacity;
    const CapMap& capacity;
    FlowMap& flow;
    const CostMap& cost;
  public:
    MinCostGenFlow(const Graph& _g, const Excess& _excess, 
		   const LCapMap& _lcapacity, const CapMap& _capacity, 
		   FlowMap& _flow, 
		   const CostMap& _cost) :
      g(_g), excess(_excess), lcapacity(_lcapacity),
      capacity(_capacity), flow(_flow), cost(_cost) { }
    void run() {
      LPSolverWrapper lp;
      lp.setMinimize();
      typedef LPSolverWrapper::ColIt ColIt;
      typedef LPSolverWrapper::RowIt RowIt;
      typedef typename Graph::template EdgeMap<ColIt> EdgeIndexMap;
      EdgeIndexMap edge_index_map(g);
      PrimalMap<typename Graph::Edge, EdgeIndexMap> lp_flow(lp, edge_index_map);
      for (typename Graph::EdgeIt e(g); e!=INVALID; ++e) {
	ColIt col_it=lp.addCol();
	edge_index_map.set(e, col_it);
	if (lcapacity[e]==capacity[e])
	  lp.setColBounds(col_it, LPX_FX, lcapacity[e], capacity[e]);
	else 
	  lp.setColBounds(col_it, LPX_DB, lcapacity[e], capacity[e]);
	lp.setObjCoef(col_it, cost[e]);
      }
      for (typename Graph::NodeIt n(g); n!=INVALID; ++n) {
	typename Graph::template EdgeMap<Num> coeffs(g, 0);
	for (typename Graph::InEdgeIt e(g, n); e!=INVALID; ++e)
	coeffs.set(e, coeffs[e]+1);
	for (typename Graph::OutEdgeIt e(g, n); e!=INVALID; ++e) 
	coeffs.set(e, coeffs[e]-1);
	RowIt row_it=lp.addRow();
	typename std::vector< std::pair<ColIt, double> > row;
	//std::cout << "node:" <<g.id(n)<<std::endl;
	for (typename Graph::EdgeIt e(g); e!=INVALID; ++e) {
	  if (coeffs[e]!=0) {
	    //std::cout << " edge:" <<g.id(e)<<" "<<coeffs[e];
	    row.push_back(std::make_pair(edge_index_map[e], coeffs[e]));
	  }
	}
	//std::cout << std::endl;
	lp.setRowCoeffs(row_it, row.begin(), row.end());
	lp.setRowBounds(row_it, LPX_FX, 0.0, 0.0);
      }
      lp.solveSimplex();
      //std::cout << lp.colNum() << std::endl;
      //std::cout << lp.rowNum() << std::endl;
      //std::cout << "flow value: "<< lp.getObjVal() << std::endl;
      for (typename Graph::EdgeIt e(g); e!=INVALID; ++e) 
      flow.set(e, lp_flow[e]);
    }
  };

} // namespace lemon

#endif //LEMON_MIN_COST_GEN_FLOW_H
