#include <kruskalbox.h>

enum {INPUT, OUTPUT, MAP_NUM};

KruskalBox::KruskalBox(std::vector<std::string> t):AlgoBox()
{
  init(t);
}
    
void KruskalBox::run()
{
  if(
     tabcbt.get_active_text()!="" &&
     (edgemapcbts[INPUT])->get_active_text()!="" &&
     (edgemapcbts[OUTPUT])->get_active_text()!=""
     )
    {

      Graph g=mapstorage->graph;
      Graph::EdgeMap<double> * inputmap=
	((mapstorage->edgemap_storage)[(edgemapcbts[INPUT])->get_active_text()]);
      Graph::EdgeMap<bool> outputmap(g);
      double res=kruskal(g, *inputmap, outputmap);

      for (EdgeIt i(g); i!=INVALID; ++i)
	{
	  if(outputmap[i])
	    {
	      (*((mapstorage->edgemap_storage)[(edgemapcbts[OUTPUT])->
					       get_active_text()]))[i]=1;
	    }
	  else
	    {
	      (*((mapstorage->edgemap_storage)[(edgemapcbts[OUTPUT])->
					       get_active_text()]))[i]=0;
	    }
	}

      std::ostringstream o;
      o << "Result: " << res;
      resultlabel.set_text(o.str());

      mapstorage->mapChanged(true, (edgemapcbts[OUTPUT])->get_active_text());
      //   mapstorage->changeActiveMap(true, E_COLOR,
      // 			      (edgemapcbts[OUTPUT])->get_active_text());
      //   mapstorage->changeActiveMap(true, E_TEXT,
      // 			      (edgemapcbts[INPUT])->get_active_text());
  
    }
}
    
void KruskalBox::build_box()
{
  std::vector<std::string> empty_vector;

  addMapSelector("Edgecosts: ", true);
  addMapSelector("Edges of tree here: ", true);

  resultlabel.set_text("Result: algorithm is not run yet.");
  pack_start(resultlabel);
}
