// -*- C++ -*- //

#ifndef NEWMAPWIN_H
#define NEWMAPWIN_H

class NewMapWin;

#include <all_include.h>
#include <nbtab.h>
#include <libgnomecanvasmm.h>
#include <libgnomecanvasmm/polygon.h>
#include <stack>

///This class is responsible for creating a window,
///on which the parameters of a new map can be set.

class NewMapWin : public Gtk::Dialog
{
  NoteBookTab & mytab;

public:
  struct tree_node
  {
    char ch;
    tree_node * left_child;
    tree_node * right_child;
  };
  
  ///Constructor of NewMapWin creates the widgets shown in NewMapWin.
  NewMapWin(const std::string& title, NoteBookTab &, bool itisedge=true, bool edgenode=true);

  ///Signal on button is connected to this function,
  ///Therefore this function determines whether to
  ///call the map/creatort function, and if yes, it
  //tells it the attributes.(name, default value)
  virtual void on_response(int response_id);

  virtual bool closeIfEscapeIsPressed(GdkEventKey*);

  ///Function that creates a tree from an appropriately manipulated string
  tree_node * weightedString2Tree(std::string, std::vector<unsigned int> &, int);

  ///Function  that creates a string from a tree by postorder reading.
  std::string postOrder(tree_node *);

  std::string string2Polishform(std::string, bool);

  bool validVariable(std::string, bool);

  void deleteTree(tree_node *);

  std::map<char, std::string> ch2var;

  Gtk::Entry name, default_value;

  Gtk::Table * table;
  Gtk::Label * label;

  Gtk::RadioButton node, edge;
};

#endif //NEWMAPWIN_H
