// -*- C++ -*-

#include <lemon/bits/undir_graph_extender.h>
#include <lemon/concept/undir_graph.h>
#include <lemon/list_graph.h>
#include <lemon/smart_graph.h>
#include <lemon/full_graph.h>

#include <lemon/graph_utils.h>

#include "test_tools.h"


using namespace lemon;
using namespace lemon::concept;

void check_concepts() {
  typedef UndirGraphExtender<ListGraphBase> UndirListGraphBase;

  typedef IterableUndirGraphExtender<
    AlterableUndirGraphExtender<UndirListGraphBase> > IterableUndirListGraph;

  typedef MappableUndirGraphExtender<IterableUndirListGraph>
    MappableUndirListGraph;

  typedef ErasableUndirGraphExtender<
    ClearableUndirGraphExtender<
    ExtendableUndirGraphExtender<MappableUndirListGraph> > > Graph;

  checkConcept<BaseIterableUndirGraphConcept, Graph>();
  checkConcept<IterableUndirGraphConcept, Graph>();
  checkConcept<MappableUndirGraphConcept, Graph>();

  checkConcept<UndirGraph, Graph>();
  checkConcept<ErasableUndirGraph, Graph>();

  checkConcept<UndirGraph, UndirListGraph>();
  checkConcept<ErasableUndirGraph, UndirListGraph>();

  checkConcept<UndirGraph, UndirSmartGraph>();
  checkConcept<ExtendableUndirGraph, UndirSmartGraph>();

  checkConcept<UndirGraph, UndirGraph>();
}

template <typename Graph>
void check_item_counts(Graph &g, int n, int e) {
  check(countNodes(g)==n, "Wrong node number.");
  check(countEdges(g)==2*e, "Wrong edge number.");
}

template <typename Graph>
void print_items(Graph &g) {

  typedef typename Graph::NodeIt NodeIt;
  typedef typename Graph::UndirEdgeIt UEdgeIt;
  typedef typename Graph::EdgeIt EdgeIt;

  cout << "Nodes" << endl;
  int i=0;
  for(NodeIt it(g); it!=INVALID; ++it, ++i) {
    cout << "  " << i << ": " << g.id(it) << endl;
  }

  cout << "UndirEdge" << endl;
  i=0;
  for(UEdgeIt it(g); it!=INVALID; ++it, ++i) {
    cout << "  " << i << ": " << g.id(it) 
	 << " (" << g.id(g.source(it)) << ", " << g.id(g.target(it)) 
	 << ")" << endl;
  }

  cout << "Edge" << endl;
  i=0;
  for(EdgeIt it(g); it!=INVALID; ++it, ++i) {
    cout << "  " << i << ": " << g.id(it)
	 << " (" << g.id(g.source(it)) << ", " << g.id(g.target(it)) 
	 << ")" << endl;
  }

}

template <typename Graph>
void check_graph() {

  typedef typename Graph::Node Node;
  typedef typename Graph::UndirEdge UEdge;
  typedef typename Graph::Edge Edge;
  typedef typename Graph::NodeIt NodeIt;
  typedef typename Graph::UndirEdgeIt UEdgeIt;
  typedef typename Graph::EdgeIt EdgeIt;

  Graph g;

  check_item_counts(g,0,0);

  Node
    n1 = g.addNode(),
    n2 = g.addNode(),
    n3 = g.addNode();

  UEdge
    e1 = g.addEdge(n1, n2),
    e2 = g.addEdge(n2, n3);

  // print_items(g);

  check_item_counts(g,3,2);


}

int main() {
  check_concepts();

  check_graph<UndirListGraph>();
  check_graph<UndirSmartGraph>();

  return 0;
}
