AC_DEFUN([LX_CHECK_GLPK],
[
  AC_ARG_WITH([glpk],
AS_HELP_STRING([--with-glpk@<:@=PREFIX@:>@], [search for GLPK under PREFIX or under the default search paths if PREFIX is not given @<:@default@:>@])
AS_HELP_STRING([--without-glpk], [disable checking for GLPK]),
              [], [with_glpk=yes])

  AC_ARG_WITH([glpk-includedir],
AS_HELP_STRING([--with-glpk-includedir=DIR], [search for GLPK headers in DIR]),
              [], [with_glpk_includedir=no])

  AC_ARG_WITH([glpk-libdir],
AS_HELP_STRING([--with-glpk-libdir=DIR], [search for GLPK libraries in DIR]),
              [], [with_glpk_libdir=no])

  lx_glpk_found=no
  if test x"$with_glpk" != x"no"; then
    AC_MSG_CHECKING([for GLPK])

    if test x"$with_glpk_includedir" != x"no"; then
      GLPK_CFLAGS="-I$with_glpk_includedir"
    elif test x"$with_glpk" != x"yes"; then
      GLPK_CFLAGS="-I$with_glpk/include"
    fi

    if test x"$with_glpk_libdir" != x"no"; then
      GLPK_LDFLAGS="-L$with_glpk_libdir"
    elif test x"$with_glpk" != x"yes"; then
      GLPK_LDFLAGS="-L$with_glpk/lib"
    fi
    GLPK_LIBS="-lglpk"

    lx_save_cxxflags="$CXXFLAGS";
    lx_save_ldflags="$LDFLAGS";
    lx_save_libs="$LIBS";
    CXXFLAGS="$GLPK_CFLAGS"
    LDFLAGS="$GLPK_LDFLAGS"
    LIBS="$GLPK_LIBS"

    lx_glpk_test_prog='
      extern "C" {
      #include <glpk.h>
      }

      int main(int argc, char* argv[])
      {
        LPX *lp;
        lp = lpx_create_prob();
        lpx_delete_prob(lp);
        return 0;
      }'

    AC_LANG_PUSH(C++)
    AC_LINK_IFELSE([$lx_glpk_test_prog], [lx_glpk_found=yes], [lx_glpk_found=no])
    AC_LANG_POP(C++)

    CXXFLAGS="$lx_save_cxxflags"
    LDFLAGS="$lx_save_ldflags"
    LIBS="$lx_save_libs"

    if test x"$lx_glpk_found" = x"yes"; then
      AC_DEFINE([HAVE_GLPK], [1], [Define to 1 if you have GLPK.])
      AC_MSG_RESULT([yes])
    else
      AC_MSG_RESULT([no])
    fi
  fi
  GLPK_LIBS="$GLPK_LDFLAGS $GLPK_LIBS"
  AC_SUBST(GLPK_CFLAGS)
  AC_SUBST(GLPK_LIBS)
  AM_CONDITIONAL([HAVE_GLPK], [test x"$lx_glpk_found" = x"yes"])
])


AC_DEFUN([LX_CHECK_CPLEX],
[
  AC_ARG_WITH([cplex],
AS_HELP_STRING([--with-cplex@<:@=PREFIX@:>@], [search for CPLEX under PREFIX or under the default search paths if PREFIX is not given @<:@default@:>@])
AS_HELP_STRING([--without-cplex], [disable checking for CPLEX]),
              [], [with_cplex=yes])

  AC_ARG_WITH([cplex-includedir],
AS_HELP_STRING([--with-cplex-includedir=DIR], [search for CPLEX headers in DIR]),
              [], [with_cplex_includedir=no])

  AC_ARG_WITH([cplex-libdir],
AS_HELP_STRING([--with-cplex-libdir=DIR], [search for CPLEX libraries in DIR]),
              [], [with_cplex_libdir=no])

  lx_cplex_found=no
  if test x"$with_cplex" != x"no"; then
    AC_MSG_CHECKING([for CPLEX])

    if test x"$with_cplex_includedir" != x"no"; then
      CPLEX_CFLAGS="-I$with_cplex_includedir"
    elif test x"$with_cplex" != x"yes"; then
      CPLEX_CFLAGS="-I$with_cplex/include"
    fi

    if test x"$with_cplex_libdir" != x"no"; then
      CPLEX_LDFLAGS="-L$with_cplex_libdir"
    elif test x"$with_cplex" != x"yes"; then
      CPLEX_LDFLAGS="-L$with_cplex/lib"
    fi
    CPLEX_LIBS="-lcplex -lm -lpthread"

    lx_save_cxxflags="$CXXFLAGS";
    lx_save_ldflags="$LDFLAGS";
    lx_save_libs="$LIBS";
    CXXFLAGS="$CPLEX_CFLAGS"
    LDFLAGS="$CPLEX_LDFLAGS"
    LIBS="$CPLEX_LIBS"

    lx_cplex_test_prog='
      extern "C" {
      #include <ilcplex/cplex.h>
      }

      int main(int argc, char* argv[])
      {
	CPXENVptr env = NULL;
        return 0;
      }'

    AC_LANG_PUSH(C++)
    AC_LINK_IFELSE([$lx_cplex_test_prog], [lx_cplex_found=yes], [lx_cplex_found=no])
    AC_LANG_POP(C++)

    CXXFLAGS="$lx_save_cxxflags"
    LDFLAGS="$lx_save_ldflags"
    LIBS="$lx_save_libs"

    if test x"$lx_cplex_found" = x"yes"; then
      AC_DEFINE([HAVE_CPLEX], [1], [Define to 1 if you have CPLEX.])
      AC_MSG_RESULT([yes])
    else
      AC_MSG_RESULT([no])
    fi
  fi
  CPLEX_LIBS="$CPLEX_LDFLAGS $CPLEX_LIBS"
  AC_SUBST(CPLEX_CFLAGS)
  AC_SUBST(CPLEX_LIBS)
  AM_CONDITIONAL([HAVE_CPLEX], [test x"$lx_cplex_found" = x"yes"])
])
