AC_DEFUN([LX_ENABLE_DOCS],
[
  AC_ARG_ENABLE([docs],
AS_HELP_STRING([--enable-docs@<:@=yes|no|full@:>@], [build the documentation (full enables internal documentation too) @<:@default=yes@:>@])
AS_HELP_STRING([--disable-docs], [do not build the documentation]),
         [], [enable_docs=yes])

  AC_MSG_CHECKING([whether to build the documention])
  case "$enable_docs" in
    yes)
      DOXYGEN_INTERNAL_DOCS=NO
      AC_MSG_RESULT([yes])
      ;;
    full)
      DOXYGEN_INTERNAL_DOCS=YES
      AC_MSG_RESULT([full])
      ;;
    no)
      DOXYGEN_INTERNAL_DOCS=NO
      AC_MSG_RESULT([no])
      ;;
    *)
      AC_MSG_ERROR([bad value $enable_docs for option --enable-docs])
      ;;
  esac
  AC_SUBST(DOXYGEN_INTERNAL_DOCS)
  AM_CONDITIONAL([WANT_DOCS], [test x"$enable_docs" != x"no"])
])

AC_DEFUN([LX_ENABLE_GUI],
[
  AC_ARG_ENABLE([gui],
AS_HELP_STRING([--enable-gui], [build the GUI])
AS_HELP_STRING([--disable-gui], [do not build the GUI @<:@default@:>@]),
         [], [enable_gui=no])

  AC_MSG_CHECKING([whether to build the GUI])
  if test x"$enable_gui" != x"no"; then
      AC_MSG_RESULT([yes])
  else
      AC_MSG_RESULT([no])
  fi
  if test x"$enable_gui" != x"no"; then
    PKG_CHECK_MODULES([GTK], [libgnomecanvasmm-2.6 >= 2.6.0])
  fi
  AM_CONDITIONAL([WANT_GUI], [test x"$enable_gui" != x"no"])
])
