#include <iostream>
#include <fstream>

#include <j_graph.h>
#include <dimacs_jgraph.hh>
#include <preflow_jgraph.h>
#include <time_measure.h>

using namespace hugo;

// Use a DIMACS max flow file as stdin.
// read_dimacs_demo < dimacs_max_flow_file
int main(int, char **) {
  typedef JGraph::TrivNodeIt TrivNodeIt;
  typedef JGraph::EdgeIt EdgeIt;

  JGraph G;
  TrivNodeIt s, t;
  JGraph::EdgeMap<int> cap(G);
  readDimacsMaxFlow(std::cin, G, s, t, cap);

  std::cout << "preflow demo jacint ..." << std::endl;
  
  double mintime=1000000;

  for ( int i=1; i!=11; ++i ) {
    double pre_time=currTime();
    preflow<JGraph, int> max_flow_test(G, s, t, cap);
    double post_time=currTime();
    if ( mintime > post_time-pre_time ) mintime = post_time-pre_time;
  }

  double pre_time=currTime();
    preflow<JGraph, int> max_flow_test(G, s, t, cap);
  double post_time=currTime();
    
  JGraph::NodeMap<bool> cut(G);
  max_flow_test.minCut(cut); 
  int min_cut_value=0;
  for(EdgeIt e=G.firstEdge(); e; G.next(e)) {
    if (cut.get(G.tail(e)) && !cut.get(G.head(e))) min_cut_value+=cap.get(e);
  }

  JGraph::NodeMap<bool> cut1(G);
  max_flow_test.minMinCut(cut1); 
  int min_min_cut_value=0;
  for(EdgeIt e=G.firstEdge(); e; G.next(e)) {
    if (cut.get(G.tail(e)) && !cut.get(G.head(e))) 
      min_min_cut_value+=cap.get(e);
  }

  JGraph::NodeMap<bool> cut2(G);
  max_flow_test.maxMinCut(cut2); 
  int max_min_cut_value=0;
  for(EdgeIt e=G.firstEdge(); e; G.next(e)) {
    if (cut2.get(G.tail(e)) && !cut2.get(G.head(e))) 
      max_min_cut_value+=cap.get(e);
  }
  
  std::cout << "min time of 10 runs: " << mintime << " sec"<< std::endl; 
  std::cout << "phase 0: " << max_flow_test.time-pre_time 
	    << " sec"<< std::endl; 
  std::cout << "phase 1: " << post_time-max_flow_test.time 
	    << " sec"<< std::endl; 
  std::cout << "flow value: "<< max_flow_test.maxFlow() << std::endl;
  std::cout << "min cut value: "<< min_cut_value << std::endl;
  std::cout << "min min cut value: "<< min_min_cut_value << std::endl;
  std::cout << "max min cut value: "<< max_min_cut_value << 
    std::endl<< std::endl;
  
  return 0;
}
