// -*- c++ -*-
//randomGraph(i,j) gives a random graph on i nodes and j edges.
#include <vector>
#include <cstdlib>

//#include <list_graph.h>
//#include <time_measure.h>
//#include <for_each_macros.h>
//#include <bfs_iterator.h>
//#include <bipartite_graph_wrapper.h>
//#include <maps.h>
//#include <max_flow.h>

namespace hugo {


  /**
   * Inicializalja a veletlenszamgeneratort.
   * Figyelem, ez nem jo igazi random szamokhoz,
   * erre ne bizzad a titkaidat!
   */
  void random_init()
  {
    unsigned int seed = getpid();
    seed |= seed << 15;
    seed ^= time(0);

    srand(seed);
  }


  /**
   * Egy veletlen int-et ad vissza 0 es m-1 kozott.
   */
  int random(int m)
  {
    return int( double(m) * rand() / (RAND_MAX + 1.0) );
  }


  template<typename Graph>
  void randomGraph (Graph& g, int n, int m) {
    typedef typename Graph::Node Node;
    g.clear();
    std::vector<Node> nodes;
    for (int i=0; i<n; ++i)
      nodes.push_back(g.addNode());
    for (int i=0; i<m; ++i) 
      g.addEdge(nodes[random(n)], nodes[random(n)]);
  }

}
