#include <all_include.h>
#include <mapstorage.h>
#include <main_win.h>
#include <libgnomecanvasmm.h>
#include <libgnomecanvasmm/polygon.h>

#define MAIN_PART

std::vector <std::string> property_strings;
std::vector <double> property_defaults;


int main(int argc, char *argv[])
{

  //initializing

  property_strings.resize(PROPERTY_NUM);
  property_strings[WIDTH]="Width";
  property_strings[COLOR]="Color";
  property_strings[TEXT]="Text";

  property_defaults.resize(PROPERTY_NUM);
  property_defaults[WIDTH]=10.0;
  property_defaults[COLOR]=100;
  property_defaults[TEXT]=0;

  if(argc<2)
  {
      std::cerr << "USAGE: gd <input filename.lgf>" << std::endl;
      return 0;
  }

  Coordinates coosvector;

  Graph g;

  CoordinatesMap cm(g);
  Graph::EdgeMap<double> cap(g), map1(g), map2(g), map3(g), map4(g);
  Graph::NodeMap<double> nodedata (g);

  //we create one object to read x coordinates
  //and one to read y coordinate of nodes and write them to cm NodeMap.
  XMap <CoordinatesMap> xreader (cm);
  YMap <CoordinatesMap> yreader (cm);

  //reading in graph and its maps

  std::ifstream is(argv[1]);

  GraphReader<Graph> reader(is, g);
  reader.readNodeMap("coordinates_x", xreader);
  reader.readNodeMap("coordinates_y", yreader);
  reader.readNodeMap("data", nodedata);
  reader.readEdgeMap("cap", cap);
  reader.readEdgeMap("map1", map1);
  reader.readEdgeMap("map2", map2);
  reader.readEdgeMap("map3", map3);
  reader.readEdgeMap("map4", map4);
  reader.run();

  //initializing MapStorage with the read data

  MapStorage ms(g);
  ms.addNodeMap("data",&nodedata);
  ms.addEdgeMap("cap",&cap);
  ms.addEdgeMap("map1",&map1);
  ms.addEdgeMap("map2",&map2);
  ms.addEdgeMap("map3",&map3);
  ms.addEdgeMap("map4",&map4);

  //initializing GUI

  Gnome::Canvas::init();
  Gtk::Main app(argc, argv);

  MainWin mainwin("Displayed Graph", g, cm, ms);
  app.run(mainwin);

  return 0;
}
