/* -*- C++ -*-
 *
 * This file is a part of LEMON, a generic C++ optimization library
 *
 * Copyright (C) 2003-2007
 * Egervary Jeno Kombinatorikus Optimalizalasi Kutatocsoport
 * (Egervary Research Group on Combinatorial Optimization, EGRES).
 *
 * Permission to use, modify and distribute this software is granted
 * provided that this copyright notice appears in all copies. For
 * precise terms see the accompanying LICENSE file.
 *
 * This software is provided "AS IS" with no warranty of any kind,
 * express or implied, and with no claim as to its suitability for any
 * purpose.
 *
 */


///\ingroup demos
///\file
///\brief Mixed integer program solver demo
///
/// This example shows how can we solve an integer program with lemon
/// \c Mip interface and with default solver.
///
/// \include mip_demo.cc

#include <lemon/lp.h>

using namespace lemon;

int main(){

   Mip ilp;


  typedef Mip::Row Row;
  typedef Mip::Col Col;
  
  ilp.max();
  
  Col x1 = ilp.addCol();
  Col x2 = ilp.addCol();
  Col x3 = ilp.addCol();
  
  ilp.integer(x1,true);
  ilp.integer(x2,true);
  ilp.integer(x3,true);
  
  ilp.addRow(x1+x2+x3 <=100);  
  ilp.addRow(10*x1+4*x2+5*x3<=600);  
  ilp.addRow(2*x1+2*x2+6*x3<=300); 
  
  ilp.colLowerBound(x1, 0);
  ilp.colLowerBound(x2, 0);
  ilp.colLowerBound(x3, 0);
  //Objective function
  ilp.obj(10*x1+6*x2+4*x3);
  
  //Call the routine of the underlying LP solver
  ilp.solve();
  
  //Print results
  if (ilp.primalStatus()==LpSolverBase::OPTIMAL){
    std::cout<<"Optimal solution found!"<<std::endl;
    printf("optimum value = %g; x1 = %g; x2 = %g; x3 = %g\n", 
           ilp.primalValue(), 
           ilp.primal(x1), ilp.primal(x2), ilp.primal(x3));
  }
  else{
    std::cout<<"Optimal solution not found!"<<std::endl;
  }

}
