#ifndef EDGE_MAP_REGISTRY_H
#define EDGE_MAP_REGISTRY_H

#include <vector>

template <typename G, typename K>
class EdgeMapRegistry;

#include "edge_map_base.h"

template <typename G, typename K>
class EdgeMapRegistry {
public:
	typedef G Graph;
	typedef K Edge;
	
	typedef EdgeMapBase<Graph, Edge> MapBase;
	friend class MapBase;

protected:
	
	Graph* graph;

	typedef std::vector<MapBase*> Container; 
	
	Container container;

public:

	EdgeMapRegistry(Graph g) : graph(&g) {}

	void add(MapBase& map_base) {
		if (map_base.graph) {
			map_base.graph->edge_maps.erase(map_base);
		}
		container.push_back(&map_base);
		map_base.graph = graph;
		map_base.graph_index = container.size()-1;
	} 
	
	void erase(MapBase& map_base) {
		container.back()->graph_index = map_base.graph_index; 
		container[map_base.graph_index] = container.back();
		container.pop_back();
		map_base.graph = 0;
	}

	
	void add(Edge& edge) {
		typename Container::iterator it;
		for (it = container.begin(); it != container.end(); ++it) {
			(*it)->add(edge);
		}
	}
	
	void erase(Edge& edge) {
		typename Container::iterator it;
		for (it = container.begin(); it != container.end(); ++it) {
			(*it)->erase(edge);
		}
	}

};

#endif
