#ifndef NODE_MAP_REGISTRY_H
#define NODE_MAP_REGISTRY_H

#include <vector>

template <typename G, typename K>
class NodeMapRegistry;

#include "node_map_base.h"

template <typename G, typename K>
class NodeMapRegistry {
public:
	typedef G Graph;
	typedef K Node;
	
	typedef NodeMapBase<Graph, Node> MapBase;
	friend class MapBase;

protected:
	
	Graph* graph;

	typedef std::vector<MapBase*> Container; 
	
	Container container;

public:

	NodeMapRegistry(Graph g) : graph(&g) {}

	void add(MapBase& map_base) {
		if (map_base.graph) {
			map_base.graph->node_maps.erase(map_base);
		}
		container.push_back(&map_base);
		map_base.graph = graph;
		map_base.graph_index = container.size()-1;
	} 
	
	void erase(MapBase& map_base) {
		container.back()->graph_index = map_base.graph_index; 
		container[map_base.graph_index] = container.back();
		container.pop_back();
		map_base.graph = 0;
	}

	
	void add(Node& node) {
		typename Container::iterator it;
		for (it = container.begin(); it != container.end(); ++it) {
			(*it)->add(node);
		}
	}
	
	void erase(Node& node) {
		typename Container::iterator it;
		for (it = container.begin(); it != container.end(); ++it) {
			(*it)->erase(node);
		}
	}

};

#endif
