#ifndef VECTOR_MAP_H
#define VECTOR_MAP_H

#include <vector>

template <typename G, typename K, typename V, template <typename, typename> class MapBase > 
class VectorMap : public MapBase<G, K> {
public:
	typedef V ValueType;
	
	VectorMap() {}
	VectorMap(G& g) : MapBase<G, K>(g) {
		init();
	}
	
	~VectorMap() {
//		destroy();
	} 
	
	ValueType& operator[](const K& key) {
		return container[key->id];
	} 
	
	const ValueType& operator[](const K& key) const {
		return container[key->id];
	}
	
	const ValueType& get(const K& key) const {
		return container[key->id];
	} 
	
	void set(const K& key, const ValueType& val) {
		container[key->id] = val;
	}
	
	void add(const K& key) {
		if (key->id() >= container.size()) {
			container.resize(key->id() + 1);
		}
	}
	
	void erase(const K& key) {}

private:
	typedef std::vector<ValueType> Container;
	
	Container container;
};

#endif
