#include <string>
#include <iostream>
#include <map>
#include <vector>

#include <ma_order.h>
#include <list_graph.h>


using namespace std;
using namespace hugo;

int main() {

  typedef ListGraph::Node Node;
  typedef ListGraph::Edge Edge;
  typedef ListGraph::NodeIt NodeIt;
  typedef ListGraph::EdgeIt EdgeIt;

  ListGraph G;

  Node v3=G.addNode();
  Node v5=G.addNode();
  Node v2=G.addNode();
  Node v0=G.addNode();
  Node v4=G.addNode();
  Node v1=G.addNode();
  
  G.addEdge(v0, v1);G.addEdge(v0, v1);G.addEdge(v0, v1);
  G.addEdge(v0, v2);
  G.addEdge(v0, v3);G.addEdge(v0, v3);
  G.addEdge(v1, v2);G.addEdge(v1, v2);
  G.addEdge(v2, v4);
  G.addEdge(v3, v4);
  G.addEdge(v4, v5);

  G.addEdge(v1, v0);G.addEdge(v1, v0);G.addEdge(v1, v0);
  G.addEdge(v2, v0);
  G.addEdge(v3, v0);G.addEdge(v3, v0);
  G.addEdge(v2, v1);G.addEdge(v2, v1);
  G.addEdge(v4, v2);
  G.addEdge(v4, v3);
  G.addEdge(v5, v4);


  vector<Node> ma_order;
  MAOrder<ListGraph>  mao(G,ma_order);
  mao.run(v0);
  vector<Node>::iterator i;
  for (i = ma_order.begin(); i!=ma_order.end(); ++i) {
    cout << *i << " ";
  }
  cout << endl;
  cout << v0 << " " << v1 << " " << v2 << " " << v3 << " " << v4 << " "
       << v5 << endl;

}
