// -*- c++ -*-
#include <iostream>
#include <fstream>
#include <vector>

#include <list_graph.h>
#include <smart_graph.h>
//#include <dimacs.h>
#include <time_measure.h>
#include <for_each_macros.h>
#include <bfs_iterator.h>
#include <graph_wrapper.h>

using namespace hugo;

int main() {
  typedef UndirListGraph Graph; 
  typedef Graph::Node Node;
  typedef Graph::NodeIt NodeIt;
  typedef Graph::Edge Edge;
  typedef Graph::EdgeIt EdgeIt;
  typedef Graph::OutEdgeIt OutEdgeIt;

  Graph g;
  //Node s, t;
  //Graph::EdgeMap<int> cap(g);
  //readDimacsMaxFlow(std::cin, g, s, t, cap);
  std::vector<Graph::Node> s_nodes;
  std::vector<Graph::Node> t_nodes;
  for (int i=0; i<3; ++i) s_nodes.push_back(g.addNode());
  for (int i=0; i<3; ++i) t_nodes.push_back(g.addNode());
  g.addEdge(s_nodes[0], t_nodes[2]);
  g.addEdge(t_nodes[1], s_nodes[2]);
  
  Graph::NodeMap<int> ref_map(g, -1);
  IterableBoolMap< Graph::NodeMap<int> > bipartite_map(ref_map);
  for (int i=0; i<3; ++i) bipartite_map.insert(s_nodes[i], false);
  for (int i=0; i<3; ++i) bipartite_map.insert(t_nodes[i], true);
  typedef BipartiteGraphWrapper<Graph> BGW;
  BGW bgw(g, bipartite_map);
  FOR_EACH_LOC(BGW::EdgeIt, e, bgw) {
    std::cout << bgw.tail(e) << "->" << bgw.head(e) << std::endl;
  }
//   Graph::NodeMap<OutEdgeIt> pred(G);
//   Timer ts;
//   {
//     ts.reset();
//     Graph::NodeMap<bool> reached(G);
//     reached.set(s, true);
//     pred.set(s, INVALID);
//     std::queue<Node> bfs_queue;
//     bfs_queue.push(t);
//     while (!bfs_queue.empty()) {
//       Node v=bfs_queue.front();	
//       bfs_queue.pop();
//       OutEdgeIt e;
//       for(G.first(e,v); G.valid(e); G.next(e)) {
// 	Node w=G.head(e);
// 	if (!reached[w]) {
// 	  bfs_queue.push(w);
// 	  reached.set(w, true);
// 	  pred.set(w, e);
// 	}
//       }
//     }

//     std::cout << ts << std::endl;
//   }

//   {
//     ts.reset();      
//     BfsIterator< Graph, Graph::NodeMap<bool> > bfs(G);
//     bfs.pushAndSetReached(s);
//     pred.set(s, INVALID);
//     while (!bfs.finished()) { 
//       ++bfs; 
//       if (G.valid(bfs) && bfs.isBNodeNewlyReached()) 
// 	pred.set(bfs.bNode(), bfs);
//     }
//     std::cout << ts << std::endl;
//   }

  return 0;
}
