#include <graph_displayer_canvas.h>
#include <broken_edge.h>
#include <math.h>


bool GraphDisplayerCanvas::on_expose_event(GdkEventExpose *event)
{
  Gnome::Canvas::CanvasAA::on_expose_event(event);
  //usleep(10000);
  //rezoom();
  return true;
}

void GraphDisplayerCanvas::changeEditorialTool(int newtool)
{
  if(actual_tool!=newtool)
    {

      actual_handler.disconnect();

      switch(actual_tool)
	{
	case CREATE_EDGE:
	  {
	    GdkEvent * generated=new GdkEvent();
	    generated->type=GDK_BUTTON_RELEASE;
	    generated->button.button=3;
	    createEdgeEventHandler(generated);      
	    break;
	  }
	case EDGE_MAP_EDIT:
	  //has to do the same thing as in the case of NODE_MAP_EDIT
	case NODE_MAP_EDIT:
	  {
	    GdkEvent * generated=new GdkEvent();
	    generated->type=GDK_KEY_PRESS;
	    ((GdkEventKey*)generated)->keyval=GDK_KP_Enter;
	    entryWidgetChangeHandler(generated);
	    entrywidget.hide();
	    break;
	  }
	default:
	  break;
	}

      active_item=NULL; 
      target_item=NULL; 
      active_edge=INVALID;	
      active_node=INVALID;	


      actual_tool=newtool;
  
      switch(newtool)
	{
	case MOVE:
	  actual_handler=signal_event().connect(sigc::mem_fun(*this, &GraphDisplayerCanvas::moveEventHandler), false);
	  break;

	case CREATE_NODE:
	  actual_handler=signal_event().connect(sigc::mem_fun(*this, &GraphDisplayerCanvas::createNodeEventHandler), false);
	  break;

	case CREATE_EDGE:
	  actual_handler=signal_event().connect(sigc::mem_fun(*this, &GraphDisplayerCanvas::createEdgeEventHandler), false);
	  break;

	case ERASER:
	  actual_handler=signal_event().connect(sigc::mem_fun(*this, &GraphDisplayerCanvas::eraserEventHandler), false);
	  break;

	case EDGE_MAP_EDIT:
	  grab_focus();
	  actual_handler=signal_event().connect(sigc::mem_fun(*this, &GraphDisplayerCanvas::edgeMapEditEventHandler), false);
	  break;

	case NODE_MAP_EDIT:
	  actual_handler=signal_event().connect(sigc::mem_fun(*this, &GraphDisplayerCanvas::nodeMapEditEventHandler), false);
	  break;

	default:
	  break;
	}
    }
}

int GraphDisplayerCanvas::getActualTool()
{
  return actual_tool;
}

bool GraphDisplayerCanvas::moveEventHandler(GdkEvent* e)
{
  switch(e->type)
  {
    case GDK_BUTTON_PRESS:
      //we mark the location of the event to be able to calculate parameters of dragging
      window_to_world (e->button.x, e->button.y, clicked_x, clicked_y);

      active_item=(get_item_at(clicked_x, clicked_y));
      active_node=INVALID;
      for (NodeIt i(g); i!=INVALID; ++i)
	{
	  if(nodesmap[i]==active_item)
	    {
	      active_node=i;
	    }
	}
      switch(e->button.button)
	{
	case 3:      
	  isbutton=3;
	  break;
	default:
	  isbutton=1;
	  break;
	}
      break;
    case GDK_BUTTON_RELEASE:
      isbutton=0;
      active_item=NULL;
      active_node=INVALID;
      break;
    case GDK_MOTION_NOTIFY:
      //we only have to do sg. if the mouse button is pressed AND the click was on a node that was found in the set of nodes
      if(active_node!=INVALID)
      {
	//new coordinates will be the old values,
	//because the item will be moved to the
	//new coordinate therefore the new movement
	//has to be calculated from here

	double new_x, new_y;

	window_to_world (e->motion.x, e->motion.y, new_x, new_y);

        double dx=new_x-clicked_x;
        double dy=new_y-clicked_y;

	//repositioning node and its text
        active_item->move(dx, dy);
	nodetextmap[active_node]->move(dx, dy);

        clicked_x=new_x;
        clicked_y=new_y;

	//all the edges connected to the moved point has to be redrawn
        EdgeIt ei;

        g.firstOut(ei,active_node);

        for(;ei!=INVALID;g.nextOut(ei))
        {
            Gnome::Canvas::Points coos;
            double x1, x2, y1, y2;

            nodesmap[g.source(ei)]->get_bounds(x1, y1, x2, y2);
            coos.push_back(Gnome::Art::Point((x1+x2)/2,(y1+y2)/2));

            nodesmap[g.target(ei)]->get_bounds(x1, y1, x2, y2);
            coos.push_back(Gnome::Art::Point((x1+x2)/2,(y1+y2)/2));

	    if(isbutton==3)
	      {
		edgesmap[ei]->setPoints(coos);
	      }
	    else
	      {
		edgesmap[ei]->setPoints(coos,true);
	      }

	    //reposition of edgetext
	    xy<double> text_pos=edgesmap[ei]->getArrowPos();
	    text_pos+=(xy<double>(10,10));
	    edgetextmap[ei]->property_x().set_value(text_pos.x);
	    edgetextmap[ei]->property_y().set_value(text_pos.y);
        }

        g.firstIn(ei,active_node);
        for(;ei!=INVALID;g.nextIn(ei))
        {
            Gnome::Canvas::Points coos;
            double x1, x2, y1, y2;

            nodesmap[g.source(ei)]->get_bounds(x1, y1, x2, y2);
            coos.push_back(Gnome::Art::Point((x1+x2)/2,(y1+y2)/2));

            nodesmap[g.target(ei)]->get_bounds(x1, y1, x2, y2);
            coos.push_back(Gnome::Art::Point((x1+x2)/2,(y1+y2)/2));

	    if(isbutton==3)
	      {
		edgesmap[ei]->setPoints(coos);
	      }
	    else
	      {
		edgesmap[ei]->setPoints(coos,true);
	      }

	    xy<double> text_pos=edgesmap[ei]->getArrowPos();
	    text_pos+=(xy<double>(10,10));
	    edgetextmap[ei]->property_x().set_value(text_pos.x);
	    edgetextmap[ei]->property_y().set_value(text_pos.y);
        }
      }
    default: break;
  }

  return false;
}

bool GraphDisplayerCanvas::createNodeEventHandler(GdkEvent* e)
{
  switch(e->type)
    {

      //draw the new node in red at the clicked place
    case GDK_2BUTTON_PRESS:
      std::cout << "double click" << std::endl;
      break;
    case GDK_BUTTON_PRESS:
      isbutton=1;

      active_node=NodeIt(g,g.addNode());

      //initiating values corresponding to new node in maps

      window_to_world (e->button.x, e->button.y, clicked_x, clicked_y);

      nodesmap[active_node]=new Gnome::Canvas::Ellipse(displayed_graph, clicked_x-20, clicked_y-20, clicked_x+20, clicked_y+20);
      active_item=(Gnome::Canvas::Item *)(nodesmap[active_node]);
      *(nodesmap[active_node]) << Gnome::Canvas::Properties::fill_color("red");
      *(nodesmap[active_node]) << Gnome::Canvas::Properties::outline_color("black");
      (nodesmap[active_node])->show();

      nodetextmap[active_node]=new Gnome::Canvas::Text(displayed_graph, clicked_x+node_property_defaults[N_RADIUS]+5, clicked_y+node_property_defaults[N_RADIUS]+5, "");
      nodetextmap[active_node]->property_fill_color().set_value("darkblue");

      mapwin->updateNode(active_node);

      break;

      //move the new node
    case GDK_MOTION_NOTIFY:
      {
	GdkEvent * generated=new GdkEvent();
	generated->motion.x=e->motion.x;
	generated->motion.y=e->motion.y;
	generated->type=GDK_MOTION_NOTIFY;
	moveEventHandler(generated);      
	break;
      }

      //finalize the new node
    case GDK_BUTTON_RELEASE:
      window_to_world (e->button.x, e->button.y, clicked_x, clicked_y);

      active_item->lower_to_bottom();

      target_item=NULL;
      target_item=get_item_at(clicked_x, clicked_y);

      active_item->raise_to_top();

      isbutton=0;
      if(target_item==active_item)
	{
	  //Its appropriate color is given by update.
	  *active_item << Gnome::Canvas::Properties::fill_color("blue");
	}
      else
	{
	  //In this case the given color has to be overwritten, because the noe covers an other item.
	  *active_item << Gnome::Canvas::Properties::fill_color("lightblue");
	}
      target_item=NULL;
      active_item=NULL;
      active_node=INVALID;
      break;
    default:
      break;
    }
  return false;
}

bool GraphDisplayerCanvas::createEdgeEventHandler(GdkEvent* e)
{
  switch(e->type)
    {
    case GDK_BUTTON_PRESS:
      //in edge creation right button has special meaning
      if(e->button.button!=3)
	{
	  //there is not yet selected node
	  if(active_node==INVALID)
	    {
	      //we mark the location of the event to be able to calculate parameters of dragging

	      window_to_world (e->button.x, e->button.y, clicked_x, clicked_y);

	      active_item=(get_item_at(clicked_x, clicked_y));
	      active_node=INVALID;
	      for (NodeIt i(g); i!=INVALID; ++i)
		{
		  if(nodesmap[i]==active_item)
		    {
		      active_node=i;
		    }
		}
	      //the clicked item is really a node
	      if(active_node!=INVALID)
		{
		  *(nodesmap[active_node]) << Gnome::Canvas::Properties::fill_color("red");
		  isbutton=1;
		}
	      //clicked item was not a node. It could be e.g. edge.
	      else
		{
		  active_item=NULL;
		}
	    }
	  //we only have to do sg. if the mouse button
	  // is pressed already once AND the click was
	  // on a node that was found in the set of 
	  //nodes, and now we only search for the second 
	  //node
	  else
	    {
	      window_to_world (e->button.x, e->button.y, clicked_x, clicked_y);
	      target_item=(get_item_at(clicked_x, clicked_y));
	      Graph::NodeIt target_node=INVALID;
	      for (NodeIt i(g); i!=INVALID; ++i)
		{
		  if(nodesmap[i]==target_item)
		    {
		      target_node=i;
		    }
		}
	      //the clicked item is a node, the edge can be drawn
	      if(target_node!=INVALID)
		{
		  if(target_node!=active_node)		
		    {
		      *(nodesmap[target_node]) << Gnome::Canvas::Properties::fill_color("red");

		      //creating new edge
		      active_edge=EdgeIt(g,g.addEdge(active_node, target_node));

		      //initiating values corresponding to new edge in maps
		      mapstorage.initMapsForEdge(active_edge);
	  
		      //calculating coordinates of new edge
		      Gnome::Canvas::Points coos;
		      double x1, x2, y1, y2;
	  
		      active_item->get_bounds(x1, y1, x2, y2);
		      coos.push_back(Gnome::Art::Point((x1+x2)/2,(y1+y2)/2));

		      target_item->get_bounds(x1, y1, x2, y2);
		      coos.push_back(Gnome::Art::Point((x1+x2)/2,(y1+y2)/2));

		      //drawing new edge
		      edgesmap[active_edge]=new BrokenEdge(displayed_graph, coos, *this);
		      *(edgesmap[active_edge]) << Gnome::Canvas::Properties::fill_color("green");
		      edgesmap[active_edge]->property_width_pixels().set_value(10);

		      //redraw nodes to blank terminations of the new edge
		      target_item->raise_to_top();
		      active_item->raise_to_top();

		      //initializing edge-text as well, to empty string
		      xy<double> text_pos=edgesmap[active_edge]->getArrowPos();
		      text_pos+=(xy<double>(10,10));

		      edgetextmap[active_edge]=new Gnome::Canvas::Text(displayed_graph, text_pos.x, text_pos.y, "");
		      edgetextmap[active_edge]->property_fill_color().set_value("darkgreen");

		      //updating its properties
		      mapwin->updateEdge(active_edge);
		    }
		  else
		    {
		      target_node=INVALID;
		      std::cout << "Loop edge is not yet implemented!" << std::endl;
		    }
		}
	      //clicked item was not a node. it could be an e.g. edge. we do not deal with it furthermore.
	      else
		{
		  target_item=NULL;
		}
	    }
	}
      break;
    case GDK_BUTTON_RELEASE:
      isbutton=0;
      //we clear settings in two cases
      //1: the edge is ready (target_item has valid value)
      //2: the edge creation is cancelled with right button
      if((target_item)||(e->button.button==3))
	{
	  if(active_item)
	    {
	      *active_item << Gnome::Canvas::Properties::fill_color("blue");
	      active_item=NULL;
	    }
	  if(target_item)
	    {
	      *target_item << Gnome::Canvas::Properties::fill_color("blue");
	      target_item=NULL;
	    }
	  active_node=INVALID;
	  active_edge=INVALID;
	}
      break;
    default:
      break;
    }
  return false;
}

bool GraphDisplayerCanvas::eraserEventHandler(GdkEvent* e)
{
  switch(e->type)
    {
    case GDK_BUTTON_PRESS:
      //finding the clicked items
      window_to_world (e->button.x, e->button.y, clicked_x, clicked_y);
      active_item=(get_item_at(clicked_x, clicked_y));
      active_node=INVALID;
      active_edge=INVALID;

      //was it a node?
      for (NodeIt i(g); i!=INVALID; ++i)
	{
	  if(nodesmap[i]==active_item)
	    {
	      active_node=i;
	    }
	}
      //or was it an edge?
      if(active_node==INVALID)
	{
	  for (EdgeIt i(g); i!=INVALID; ++i)
	    {
	      if(edgesmap[i]==active_item)
		{
		  active_edge=i;
		}
	    }
	}

      //recolor activated item
      if(active_item)
	{
	  *active_item << Gnome::Canvas::Properties::fill_color("red");
	}
      break;

    case GDK_BUTTON_RELEASE:
      window_to_world (e->button.x, e->button.y, clicked_x, clicked_y);
      if(active_item)
	{
	  //the cursor was not moved since pressing it
	  if( active_item == ( get_item_at (clicked_x, clicked_y) ) )
	    {
	      //a node was found
	      if(active_node!=INVALID)
		{

		  //collecting edges to delete
		  EdgeIt e;
		  std::set<Graph::Edge> edges_to_delete;

		  g.firstOut(e,active_node);
		  for(;e!=INVALID;g.nextOut(e))
		    {
		      edges_to_delete.insert(e);
		    }

		  g.firstIn(e,active_node);
		  for(;e!=INVALID;g.nextIn(e))
		    {
		      edges_to_delete.insert(e);
		    }

		  //deleting collected edges
		  for(std::set<Graph::Edge>::iterator edge_set_it=edges_to_delete.begin();edge_set_it!=edges_to_delete.end();edge_set_it++)
		    {
		      deleteItem(*edge_set_it);
		    }
		  deleteItem(active_node);
		}
	      //a simple edge was chosen
	      else
		{
		  deleteItem(active_edge);
		}
	    }
	  //pointer was moved, deletion is cancelled
	  else
	    {
	      if(active_node!=INVALID)
		{
		  *active_item << Gnome::Canvas::Properties::fill_color("blue");
		}
	      else
		{
		  *active_item << Gnome::Canvas::Properties::fill_color("green");
		}
	    }
	}
      //reseting datas
      active_item=NULL;
      active_edge=INVALID;
      active_node=INVALID;
      break;

    case GDK_MOTION_NOTIFY:
      break;

    default:
      break;
    }
  return false;
}

bool GraphDisplayerCanvas::edgeMapEditEventHandler(GdkEvent* e)
{
  switch(e->type)
    {
    case GDK_KEY_PRESS:
      //for Escape or Enter hide the displayed widget
      {
	nodeMapEditEventHandler(e);
	break;
      }
    case GDK_BUTTON_PRESS:
      //If the click happened on an edge we place the entrywidget there and fill in the value of the activated map at that edge.
      {
	//find the activated item
	window_to_world (e->button.x, e->button.y, clicked_x, clicked_y);
	active_item=(get_item_at(clicked_x, clicked_y));

	//determine, whether it was an edge
	Graph::EdgeIt clicked_edge=INVALID;
	for (EdgeIt i(g); i!=INVALID; ++i)
	  {
	    if(edgesmap[i]==active_item)
	      {
		clicked_edge=i;
	      }
	  }
	//if it was really an edge...
	if(clicked_edge!=INVALID)
	  {
	    //If there is already edited edge, it has to be saved first
	    if(entrywidget.is_visible())
	      {
		GdkEvent * generated=new GdkEvent();
		generated->type=GDK_KEY_PRESS;
		((GdkEventKey*)generated)->keyval=GDK_KP_Enter;
		entryWidgetChangeHandler(generated);
	      }
	    //If the previous value could be saved, we can go further, otherwise not
	    if(!entrywidget.is_visible())
	      {
		//and there is activated map
		if(edgetextmap[clicked_edge]->property_text().get_value()!="")
		  {
		    //activate the general variable for it
		    active_edge=clicked_edge;
		    //delete visible widget if there is
		    if(canvasentrywidget)
		      {
			delete(canvasentrywidget);
		      }

		    //initialize the entry
		    entrywidget.show();

		    //fill in the correct value
		    entrywidget.set_text(edgetextmap[active_edge]->property_text().get_value());

		    //replace and resize the entry to the activated edge and put it in a Canvas::Widget to be able to display it on gdc
		    xy<double> entry_coos;
		    entry_coos.x=(edgetextmap[active_edge])->property_x().get_value();
		    entry_coos.x-=edgetextmap[active_edge]->property_text_width().get_value()/2;
		    entry_coos.y=(edgetextmap[active_edge])->property_y().get_value();
		    entry_coos.y-=edgetextmap[active_edge]->property_text_height().get_value()*1.5/2;
		    canvasentrywidget=new Gnome::Canvas::Widget(displayed_graph, entry_coos.x, entry_coos.y, entrywidget);
		    canvasentrywidget->property_width().set_value(edgetextmap[active_edge]->property_text_width().get_value()*1.5);
		    canvasentrywidget->property_height().set_value(edgetextmap[active_edge]->property_text_height().get_value()*1.5);
		  }
	      }
	  }
	//if it was not an edge...
	else
	  {
	    //In this case the click did not happen on an edge
	    //if there is visible entry we save the value in it
	    //we pretend like an Enter was presse din the Entry widget
	    GdkEvent * generated=new GdkEvent();
	    generated->type=GDK_KEY_PRESS;
	    ((GdkEventKey*)generated)->keyval=GDK_KP_Enter;
	    entryWidgetChangeHandler(generated);
	  }
	break;
      }
    default:
      break;
    }
  return false;  
}

bool GraphDisplayerCanvas::nodeMapEditEventHandler(GdkEvent* e)
{
  switch(e->type)
    {
    case GDK_KEY_PRESS:
      //for Escape or Enter hide the displayed widget
      {
	switch(((GdkEventKey*)e)->keyval)
	  {
	  case GDK_Escape:
	    entrywidget.hide();
	    break;
	  case GDK_Return:
	  case GDK_KP_Enter:
	    entrywidget.hide();
	    break;
	  default:
	    break;
	  }
  
	break;
      }
    case GDK_BUTTON_PRESS:
      //If the click happened on an edge we place the entrywidget there and fill in the value of the activated map at that edge.
      {
	//find the activated item
	window_to_world (e->button.x, e->button.y, clicked_x, clicked_y);
	active_item=(get_item_at(clicked_x, clicked_y));

	//determine, whether it was a node
	Graph::NodeIt clicked_node=INVALID;
	for (NodeIt i(g); i!=INVALID; ++i)
	  {
	    if(nodesmap[i]==active_item)
	      {
		clicked_node=i;
	      }
	  }

	//if it was really an edge...
	if(clicked_node!=INVALID)
	  {
	    //If there is already edited edge, it has to be saved first
	    if(entrywidget.is_visible())
	      {
		GdkEvent * generated=new GdkEvent();
		generated->type=GDK_KEY_PRESS;
		((GdkEventKey*)generated)->keyval=GDK_KP_Enter;
		entryWidgetChangeHandler(generated);
	      }
	    //If the previous value could be saved, we can go further, otherwise not
	    if(!entrywidget.is_visible())
	      {
		//and there is activated map
		if(nodetextmap[clicked_node]->property_text().get_value()!="")
		  {
		    //activate the general variable for it
		    active_node=clicked_node;
		    //delete visible widget if there is
		    if(canvasentrywidget)
		      {
			delete(canvasentrywidget);
		      }

		    //initialize the entry
		    entrywidget.show();

		    //fill in the correct value
		    entrywidget.set_text(nodetextmap[active_node]->property_text().get_value());

		    //replace and resize the entry to the activated node and put it in a Canvas::Widget to be able to display it on gdc
		    xy<double> entry_coos;
		    entry_coos.x=(nodetextmap[active_node])->property_x().get_value();
		    entry_coos.x-=nodetextmap[active_node]->property_text_width().get_value()/2;
		    entry_coos.y=(nodetextmap[active_node])->property_y().get_value();
		    entry_coos.y-=nodetextmap[active_node]->property_text_height().get_value()*1.5/2;
		    canvasentrywidget=new Gnome::Canvas::Widget(displayed_graph, entry_coos.x, entry_coos.y, entrywidget);
		    canvasentrywidget->property_width().set_value(nodetextmap[active_node]->property_text_width().get_value()*1.5);
		    canvasentrywidget->property_height().set_value(nodetextmap[active_node]->property_text_height().get_value()*1.5);
		  }
	      }
	  }
	//if it was not an edge...
	else
	  {
	    //In this case the click did not happen on an edge
	    //if there is visible entry we save the value in it
	    //we pretend like an Enter was presse din the Entry widget
	    GdkEvent * generated=new GdkEvent();
	    generated->type=GDK_KEY_PRESS;
	    ((GdkEventKey*)generated)->keyval=GDK_KP_Enter;
	    entryWidgetChangeHandler(generated);
	  }
	break;
      }
    default:
      break;
    }
  return false;  
}

bool GraphDisplayerCanvas::entryWidgetChangeHandler(GdkEvent* e)
{
  if(entrywidget.is_visible())
    {
      if(e->type==GDK_KEY_PRESS)
	{
	  switch(((GdkEventKey*)e)->keyval)
	    {
	    case GDK_Escape:
	      entrywidget.hide();
	      break;
	    case GDK_KP_Enter:
	    case GDK_Return:
	      {
		//these variables check whether the text in the entry is valid
		bool valid_double=true;
		int point_num=0;

		//getting the value from the entry and converting it to double
		Glib::ustring mapvalue_str = entrywidget.get_text();

		char * mapvalue_ch=new char [mapvalue_str.length()];
		for(int i=0;i<(int)(mapvalue_str.length());i++)
		  {
		    if(((mapvalue_str[i]<'0')||(mapvalue_str[i]>'9'))&&(mapvalue_str[i]!='.'))
		      {
			valid_double=false;
		      }
		    else
		      {
			if(mapvalue_str[i]=='.')
			  {
			    point_num++;
			  }
		      }
		    mapvalue_ch[i]=mapvalue_str[i];
		  }
  	      
		//if the text in the entry was correct
		if((point_num<=1)&&(valid_double))
		  {
		    double mapvalue_d=atof(mapvalue_ch);

		    //reconvert the double to string for the correct format
		    std::ostringstream ostr;
		    ostr << mapvalue_d;

		    //save the value to the correct place
		    switch(actual_tool)
		      {
		      case EDGE_MAP_EDIT:
			edgetextmap[active_edge]->property_text().set_value(ostr.str());
			(*(mapstorage.edgemap_storage)[edgemap_to_edit])[active_edge]=mapvalue_d;
			break;
		      case NODE_MAP_EDIT:
			nodetextmap[active_node]->property_text().set_value(ostr.str());
			(*(mapstorage.nodemap_storage)[nodemap_to_edit])[active_node]=mapvalue_d;
			break;
		      default:
			break;
		      }
		    entrywidget.hide();
		  }
		//the text in the entry was not correct for a double
		else
		  {
		    std::cout << "ERROR: only handling of double values is implemented yet!" << std::endl;
		  }

		break;
	      }
	    default:
	      break;
	    }
	}
    }
  return false;
}

void GraphDisplayerCanvas::deleteItem(NodeIt node_to_delete)
{
  delete(nodetextmap[node_to_delete]);
  delete(nodesmap[node_to_delete]);
  g.erase(node_to_delete);
}

void GraphDisplayerCanvas::deleteItem(EdgeIt edge_to_delete)
{
  delete(edgetextmap[edge_to_delete]);
  delete(edgesmap[edge_to_delete]);
  g.erase(edge_to_delete);
}

void GraphDisplayerCanvas::deleteItem(Graph::Edge edge_to_delete)
{
  delete(edgetextmap[edge_to_delete]);
  delete(edgesmap[edge_to_delete]);
  g.erase(edge_to_delete);
}

void GraphDisplayerCanvas::textReposition(xy<double> new_place)
{
  new_place+=(xy<double>(10,10));
  edgetextmap[forming_edge]->property_x().set_value(new_place.x);
  edgetextmap[forming_edge]->property_y().set_value(new_place.y);
}

void GraphDisplayerCanvas::toggleEdgeActivity(BrokenEdge* active_bre, bool on)
{
  if(on)
    {
      if(forming_edge!=INVALID)
	{
	  std::cout << "ERROR!!!! Valid edge found!" << std::endl;
	}
      else
	{
	  for (EdgeIt i(g); i!=INVALID; ++i)
	    {
	      if(edgesmap[i]==active_bre)
		{
		  forming_edge=i;
		}
	    }
	}
    }
  else
    {
      if(forming_edge!=INVALID)
	{
	  forming_edge=INVALID;
	}
      else
	{
	  std::cout << "ERROR!!!! Invalid edge found!" << std::endl;
	}
    }

}

void GraphDisplayerCanvas::addNewEdgeMap(double default_value, std::string mapname)
{
  //create the new map
  Graph::EdgeMap<double> * emptr=new Graph::EdgeMap<double> (g,default_value);
  mapstorage.addEdgeMap(mapname,emptr);

  //add it to the list of the displayable maps
  mapwin->registerNewEdgeMap(mapname);

  //display it
  changeEdgeText(mapname);
}

void GraphDisplayerCanvas::addNewNodeMap(double default_value, std::string mapname)
{
  //create the new map
  Graph::NodeMap<double> * emptr=new Graph::NodeMap<double> (g,default_value);
  mapstorage.addNodeMap(mapname,emptr);

  //add it to the list of the displayable maps
  mapwin->registerNewNodeMap(mapname);

  //display it
  changeNodeText(mapname);
}

