// -*- c++ -*-
#include <iostream>
#include <fstream>

#include <sage_graph.h>
#include <hugo/smart_graph.h>
#include <hugo/dimacs.h>
#include <hugo/time_measure.h>
//#include <graph_wrapper.h>
#include <hugo/max_flow.h>
//#include <preflow_res.h>
#include <for_each_macros.h>

using namespace hugo;

// Use a DIMACS max flow file as stdin.
// read_dimacs_demo < dimacs_max_flow_file


int main(int, char **) {

  typedef SageGraph MutableGraph;

  typedef SmartGraph Graph;
  //  typedef ListGraph Graph;
  typedef Graph::Node Node;
  typedef Graph::EdgeIt EdgeIt;


  Graph g;
  Node s, t;
  Graph::EdgeMap<int> cap(g);
  //readDimacsMaxFlow(std::cin, g, s, t, cap);
  readDimacs(std::cin, g, cap, s, t);
  Timer ts;
  Graph::EdgeMap<int> flow(g); //0 flow
  MaxFlow<Graph, int, Graph::EdgeMap<int>, Graph::EdgeMap<int> > 
    max_flow_test(g, s, t, cap, flow);

  {
    std::cout << "preflow ..." << std::endl;
    FOR_EACH_LOC(Graph::EdgeIt, e, g) flow.set(e, 0);
    ts.reset();
    max_flow_test.preflowPhase1(MaxFlow<Graph, int, Graph::EdgeMap<int>, Graph::EdgeMap<int> >::ZERO_FLOW);
    std::cout << "elapsed time: " << ts << std::endl;
    std::cout << "flow value: "<< max_flow_test.flowValue() << std::endl;
  }

  {
    std::cout << "preflow ..." << std::endl;
    FOR_EACH_LOC(Graph::EdgeIt, e, g) flow.set(e, 0);
    ts.reset();
    max_flow_test.preflowPhase1(MaxFlow<Graph, int, Graph::EdgeMap<int>, Graph::EdgeMap<int> >::ZERO_FLOW);
    std::cout << "elapsed time: " << ts << std::endl;
    std::cout << "flow value: "<< max_flow_test.flowValue() << std::endl;
  }


  return 0;
}
