#include "all_include.h"
#include "mapstorage.h"
#include "main_win.h"
#include <libgnomecanvasmm.h>
#include <libgnomecanvasmm/polygon.h>

#define MAIN_PART

std::vector <std::string> edge_property_strings;
std::vector <double> edge_property_defaults;
std::vector <std::string> node_property_strings;
std::vector <double> node_property_defaults;
int longest_property_string_length;

int main(int argc, char *argv[])
{

  //initializing

  edge_property_strings.resize(EDGE_PROPERTY_NUM);
  edge_property_strings[E_WIDTH]="Edge Width";
  edge_property_strings[E_COLOR]="Edge Color";
  edge_property_strings[E_TEXT]="Edge Text";

  edge_property_defaults.resize(EDGE_PROPERTY_NUM);
  edge_property_defaults[E_WIDTH]=10.0;
  edge_property_defaults[E_COLOR]=100;
  edge_property_defaults[E_TEXT]=0;

  node_property_strings.resize(NODE_PROPERTY_NUM);
  node_property_strings[N_RADIUS]="Node Radius";
  node_property_strings[N_COLOR]="Node Color";
  node_property_strings[N_TEXT]="Node Text";

  node_property_defaults.resize(NODE_PROPERTY_NUM);
  node_property_defaults[N_RADIUS]=20.0;
  node_property_defaults[N_COLOR]=100;
  node_property_defaults[N_TEXT]=0;

  longest_property_string_length=0;
  for(int i=0;i<EDGE_PROPERTY_NUM;i++)
    {
      int j=edge_property_strings[i].size();
      if(j>longest_property_string_length)
	{
	  longest_property_string_length=j;
	}
    }
  for(int i=0;i<NODE_PROPERTY_NUM;i++)
    {
      int j=node_property_strings[i].size();
      if(j>longest_property_string_length)
	{
	  longest_property_string_length=j;
	}
    }


  //initializing GUI

  Gnome::Canvas::init();
  Gtk::Main app(argc, argv);

  MainWin mytab;

//   if ((argc == 2) && (Glib::file_test(argv[1], Glib::FILE_TEST_IS_REGULAR)))
//     {
//       mytab.readFile(argv[1]);
//     }
  if(argc>=2)
    {
      for(int i=1;i<argc;i++)
	{
	  if(Glib::file_test(argv[i], Glib::FILE_TEST_IS_REGULAR))
	    {
	      mytab.readFile(argv[i]);
	    }
	}
    }
  else
    {
      mytab.newTab();
    }
  
  app.run(mytab);

  return 0;
}
