// -*- C++ -*- //

#ifndef MAIN_WIN_H
#define MAIN_WIN_H

class MainWin;

#include "all_include.h"
#include "mapstorage.h"
#include "map_win.h"
#include "new_map_win.h"
#include "graph_displayer_canvas.h"
#include <libgnomecanvasmm.h>
#include <libgnomecanvasmm/polygon.h>

///This class is the main window of GUI.
///It has menus, but the main part of it is the canvas.
class MainWin : public Gtk::Window
{
public:
  ///Constructor of the \ref MainWin. It creates the menu and the \ref GraphDisplayerCanvas on which the graph will be drawn.
  ///\param title is the title of the window
  MainWin();

  MapStorage mapstorage;

  void readFile(const std::string &);

protected:
  MapWin * mapwin;
  bool mapwinexists;

  ///The graph will be drawn on this \ref GraphDisplayerCanvas
  GraphDisplayerCanvas * gd_canvas;

  ///ActionGroup for menu
  Glib::RefPtr<Gtk::ActionGroup> ag;

  ///UIManager for menu
  Glib::RefPtr<Gtk::UIManager> uim;

  ///Container
  Gtk::VBox vbox;

  ///Tooltips
  Gtk::Tooltips tooltips;

  ///Callback for 'FileNew' action.
  virtual void newFile();
  ///Callback for 'FileOpen' action.
  virtual void openFile();
  ///Callback for 'FileSave' action.
  virtual void saveFile();
  ///Callback for 'FileSaveAs' action.
  virtual void saveFileAs();
  ///Callback for 'Close' action.
  virtual void close();

public:
  void propertyChange(bool, int, std::string);
  void popupNewMapWin(bool, int);

  std::string getActiveEdgeMap(int);
  std::string getActiveNodeMap(int);

  void registerNewEdgeMap(std::string);
  void registerNewNodeMap(std::string);

  void createMapWin();
  void closeMapWin();
};

#endif //MAIN_WIN_H
