/* -*- C++ -*-
 *
 * This file is a part of LEMON, a generic C++ optimization library
 *
 * Copyright (C) 2003-2006
 * Egervary Jeno Kombinatorikus Optimalizalasi Kutatocsoport
 * (Egervary Research Group on Combinatorial Optimization, EGRES).
 *
 * Permission to use, modify and distribute this software is granted
 * provided that this copyright notice appears in all copies. For
 * precise terms see the accompanying LICENSE file.
 *
 * This software is provided "AS IS" with no warranty of any kind,
 * express or implied, and with no claim as to its suitability for any
 * purpose.
 *
 */

#ifndef DIJKSTRABOX_H
#define DIJKSTRABOX_H

class AlgoBox;

#include <all_include.h>
#include <libgnomecanvasmm.h>
#include <libgnomecanvasmm/polygon.h>

///Digraphical interface to run Dijkstra algorithm.

///Child of \ref AlgoBox,
///therefore the only task to do at implementation was to
///
///-call init function with correct parameters from correctly parametrized constructor
///
///-implement \ref build_box function
///
///-implement \ref run function
class DijkstraBox : public AlgoBox
{
protected:
  ///Shows result of Dijkstra algorithm
  Gtk::Label resultlabel;


  ///Table for nodeselector widgets
  Gtk::Table table;

  ///Combobox for select source node
  Gtk::ComboBoxText source;

  ///Combobox for select target node
  Gtk::ComboBoxText target;

  ///Gets to and from node from combobox
  void get_from_to(Node &, Node &, Digraph &);

public:
  ///Calls \ref AlgoBox::init function to initialize class properly, automatically.
  DijkstraBox(std::vector<std::string> t);

  ///Prepare, run and postprocess Dijkstra algorithm.

  ///\ref glemon works only with maps filled with double values
  ///at the moment. While Dijkstra nedds a bool map as output.
  ///As postprocess this bool map should be transformed to
  ///double map.
  virtual void run();

  ///Builds the digraphical design of the interface.
  virtual void build_box();

  void maplists_updated();
};

class SuurballeBox : public DijkstraBox
{
  ///number of paths to find
  int num;
  
  ///Widget to set numbewr of paths to find
  Gtk::SpinButton * num_set;

  ///Holder widget
  Gtk::HBox hbox;

public:
  SuurballeBox(std::vector<std::string> t);
  void run();
  void build_box();
};
#endif //DIJKSTRABOX_H
