/* -*- C++ -*-
 *
 * This file is a part of LEMON, a generic C++ optimization library
 *
 * Copyright (C) 2003-2006
 * Egervary Jeno Kombinatorikus Optimalizalasi Kutatocsoport
 * (Egervary Research Group on Combinatorial Optimization, EGRES).
 *
 * Permission to use, modify and distribute this software is granted
 * provided that this copyright notice appears in all copies. For
 * precise terms see the accompanying LICENSE file.
 *
 * This software is provided "AS IS" with no warranty of any kind,
 * express or implied, and with no claim as to its suitability for any
 * purpose.
 *
 */

#include <gui_reader.h>
#include <mapstorage.h>

#include <xml.h>
#include "io_helper.h"
#include <lemon/dim2.h>
#include <vector>

// bool GuiReader::header(const std::string& line)
// {
//   std::istringstream ls(line);
//   std::string head;
//   ls >> head;
//   return head == "@gui";
// }

//void GuiReader::read(std::istream& is)
void GuiReader::operator()(std::istream& is, int& ln)
{
  using std::vector;
  using std::string;
  using std::pair;
  using std::make_pair;
  using std::string;
  using std::map;

  XmlIo x(is);

  { x("main_node_map_names", gui_data.main_node_map_names); }
  { x("gui_node_map_names", gui_data.gui_node_map_names); }

  { x("node_map_types", gui_data.node_map_types); }

  { x("main_arc_map_names", gui_data.main_arc_map_names); }
  { x("gui_arc_map_names", gui_data.gui_arc_map_names); }

  { x("arc_map_types", gui_data.arc_map_types); }

  for (vector<string>::const_iterator it = gui_data.gui_node_map_names.begin();
      it != gui_data.gui_node_map_names.end(); ++it)
  {
    MapValue::Type type = gui_data.node_map_types[*it];
    switch (type)
    {
      case MapValue::NUMERIC:
        {
          map<int, double>* p_map_data =
            new map<int, double>;
          gui_data.numeric_node_maps[*it] = p_map_data;
          { x(*it, *p_map_data); }
        }
        break;
      case MapValue::STRING:
        {
          map<int, string>* p_map_data =
            new map<int, string>;
          gui_data.string_node_maps[*it] = p_map_data;
          { x(*it, *p_map_data); }
        }
        break;
    }
  }

  for (vector<string>::const_iterator it = gui_data.gui_arc_map_names.begin();
      it != gui_data.gui_arc_map_names.end(); ++it)
  {
    MapValue::Type type = gui_data.arc_map_types[*it];
    switch (type)
    {
      case MapValue::NUMERIC:
        {
          map<int, double>* p_map_data =
            new map<int, double>;
          gui_data.numeric_arc_maps[*it] = p_map_data;
          { x(*it, *p_map_data); }
        }
        break;
      case MapValue::STRING:
        {
          map<int, string>* p_map_data =
            new map<int, string>;
          gui_data.string_arc_maps[*it] = p_map_data;
          { x(*it, *p_map_data); }
        }
        break;
    }
  }

  {
    std::string node_coords_save_dest;
    { x("node_coords_save_dest", node_coords_save_dest); }
    if (node_coords_save_dest == "gui_sect")
    {
      // read the node coorinates
      gui_data.node_coords_save_dest = MapStorage::SpecMapSaveOpts::GUI_SECT;
      { x("node_coord_map", gui_data.node_coord_map); }
    }
    else if (node_coords_save_dest == "nodeset_sect_1_map")
    {
      gui_data.node_coords_save_dest = MapStorage::SpecMapSaveOpts::NESET_SECT;
      gui_data.node_coords_save_map_num = MapStorage::SpecMapSaveOpts::ONE_MAP;
      { x("map_name", gui_data.node_coords_one_map_name); }
    }
    else if (node_coords_save_dest == "nodeset_sect_2_maps")
    {
      gui_data.node_coords_save_dest = MapStorage::SpecMapSaveOpts::NESET_SECT;
      gui_data.node_coords_save_map_num = MapStorage::SpecMapSaveOpts::TWO_MAPS;
      { x("map1_name", gui_data.node_coords_two_maps_1_name); }
      { x("map2_name", gui_data.node_coords_two_maps_2_name); }
    }
  }

  {
    std::string arrow_coords_save_dest;
    { x("arrow_coords_save_dest", arrow_coords_save_dest); }
    if (arrow_coords_save_dest == "gui_sect")
    {
      // read the arrow coorinates
      gui_data.arrow_coords_save_dest = MapStorage::SpecMapSaveOpts::GUI_SECT;
      { x("arrow_coord_map", gui_data.arrow_coord_map); }
    }
    else if (arrow_coords_save_dest == "arcset_sect_1_map")
    {
      gui_data.arrow_coords_save_dest = MapStorage::SpecMapSaveOpts::NESET_SECT;
      gui_data.arrow_coords_save_map_num = MapStorage::SpecMapSaveOpts::ONE_MAP;
      { x("map_name", gui_data.arrow_coords_one_map_name); }
    }
    else if (arrow_coords_save_dest == "arcset_sect_2_maps")
    {
      gui_data.arrow_coords_save_dest = MapStorage::SpecMapSaveOpts::NESET_SECT;
      gui_data.arrow_coords_save_map_num = MapStorage::SpecMapSaveOpts::TWO_MAPS;
      { x("map1_name", gui_data.arrow_coords_two_maps_1_name); }
      { x("map2_name", gui_data.arrow_coords_two_maps_2_name); }
    }
  }



  std::map<int, std::string> nm;
  x("active_nodemaps", nm);

  for(int i=0;i<NODE_PROPERTY_NUM;i++)
  {
    mapstorage->changeActiveMap(false, i, nm[i]);
  }

  std::map<int, std::string> em;
  x("active_arcmaps", em);
  for(int i=0;i<EDGE_PROPERTY_NUM;i++)
  {
    mapstorage->changeActiveMap(true, i, em[i]);
  }

  double attraction;
  double propulsation;
  int iteration;

  x("redesign-attraction", attraction);
  x("redesign-propulsation", propulsation);
  x("redesign-iteration", iteration);

  mapstorage->set_attraction(attraction);
  mapstorage->set_propulsation(propulsation);
  mapstorage->set_iteration(iteration);

  mapstorage->redesign_data_changed();
}

//GuiReader::GuiReader(LemonReader& reader, MapStorage* _mapstorage,
GuiReader::GuiReader(MapStorage* _mapstorage,
    MapStorage::GUISectData& _gui_data) :
  //Parent(reader),
  mapstorage(_mapstorage),
  gui_data(_gui_data)
{
}
