#ifndef MAP_VALUE_MAP_H
#define MAP_VALUE_MAP_H

#include "map_value.h"
#include <string>
#include "all_include.h"

class MapStorage;

class MapValueArcMap
{
  private:
    std::string mapName;
    MapStorage* pMapStorage;
  public:
    typedef MapValue Value;
    typedef Digraph::Arc Key;
    MapValueArcMap(const std::string&, MapStorage*);
    Value operator[](Key k) const;
    void set(Key k, Value v);
};

class MapValueNodeMap
{
  private:
    std::string mapName;
    MapStorage* pMapStorage;
  public:
    typedef MapValue Value;
    typedef Digraph::Node Key;
    MapValueNodeMap(const std::string&, MapStorage*);
    Value operator[](Key k) const;
    void set(Key k, Value v);
};

#endif
