/* -*- C++ -*-
 *
 * This file is a part of LEMON, a generic C++ optimization library
 *
 * Copyright (C) 2003-2006
 * Egervary Jeno Kombinatorikus Optimalizalasi Kutatocsoport
 * (Egervary Research Group on Combinatorial Optimization, EGRES).
 *
 * Permission to use, modify and distribute this software is granted
 * provided that this copyright notice appears in all copies. For
 * precise terms see the accompanying LICENSE file.
 *
 * This software is provided "AS IS" with no warranty of any kind,
 * express or implied, and with no claim as to its suitability for any
 * purpose.
 *
 */

#ifndef XYMAP_H
#define XYMAP_H

#include <lemon/list_graph.h>
#include <lemon/dim2.h>

template<class M>
class XYMap
{
  private:
    M *xmap, *ymap;

  public:
    typedef typename M::Key Key;
    typedef lemon::dim2::Point<typename M::Value> Value;
    XYMap() {}
    XYMap(M &_xmap, M &_ymap) : xmap(&_xmap), ymap(&_ymap) {}
    void setXMap(M &_xmap) { xmap = &_xmap; }
    void setYMap(M &_ymap) { ymap = &_ymap; }
    Value operator[](Key k) const
    {
      Value v(xmap->operator[](k), ymap->operator[](k));
      return v;
    }
    void set(Key k, Value v)
    {
      xmap->set(k, v.x);
      ymap->set(k, v.y);
    }
};

#endif
